/*
 * Decompiled with CFR 0.152.
 */
package com.blazinggames.cc;

import com.blazinggames.cc.Collapse_MouseAdapter;
import com.blazinggames.cc.ErrorMessage;
import com.blazinggames.cc.Game;
import com.blazinggames.cc.Menu;
import com.blazinggames.cc.Message;
import java.applet.Applet;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;

public class Collapse
extends Applet
implements Runnable,
ActionListener {
    private static final long serialVersionUID = 6767010100L;
    private static final String NUMLEVELS = "NUMLEVELS";
    private static final String PASS = "PW";
    private static final String NORMALSTART = "NORMALSTART";
    private static final String HARDSTART = "HARDSTART";
    static final int MENU = 0;
    static final int GAME = 1;
    static final int MESSAGE = 2;
    Menu panelMenu;
    Game panelGame;
    Message panelMessage;
    ErrorMessage panelError;
    Thread runner;
    boolean threadAlive = true;
    boolean bAnimInAction;
    int nMode;
    int nFrameCount;
    Collapse_MouseAdapter mouseAdapter;
    private String errorMessage;
    private boolean errorOccured = false;
    public Hashtable _config = new Hashtable();
    int _normalStart;
    int _hardStart;

    public void init() {
        this.setLayout(new CardLayout());
        this.panelError = new ErrorMessage("Unknown error");
        this.add("error", this.panelError);
        this.loadConfig();
        if (this.errorOccured) {
            this.showError(this.errorMessage);
            return;
        }
        this.mouseAdapter = new Collapse_MouseAdapter(this);
        this.addMouseListener(this.mouseAdapter);
        this.panelMenu = new Menu(this);
        this._normalStart = this.parseInt((String)this._config.get(NORMALSTART), 4);
        this._hardStart = this.parseInt((String)this._config.get(HARDSTART), 8);
        int num = this.parseInt((String)this._config.get(NUMLEVELS), 12);
        this.panelGame = new Game(this.mouseAdapter, this, this._normalStart, this._hardStart, num);
        this.panelGame.setLevel(this, 0);
        this.panelMessage = new Message(this);
        this.panelMessage.addMouseListener(this.mouseAdapter);
        this.add("menu", this.panelMenu);
        this.add("game", this.panelGame);
        this.add("message", this.panelMessage);
        ((CardLayout)this.getLayout()).show(this, "menu");
        this.requestFocus();
        this.nMode = 0;
        this.setBlockColors();
        this.repaint();
    }

    private void setBlockColors() {
        System.out.println("Analyzing parameters");
        String sTemp = this.getParameter("color1");
        if (sTemp != null) {
            System.out.println("Setting color 1");
            Game.colorBlocks[1] = this.parseColor(sTemp);
        }
        if ((sTemp = this.getParameter("color2")) != null) {
            Game.colorBlocks[2] = this.parseColor(sTemp);
        }
        if ((sTemp = this.getParameter("color3")) != null) {
            Game.colorBlocks[3] = this.parseColor(sTemp);
        }
        if ((sTemp = this.getParameter("color4")) != null) {
            Game.colorBlocks[4] = this.parseColor(sTemp);
        }
        if ((sTemp = this.getParameter("color5")) != null) {
            Game.colorBlocks[5] = this.parseColor(sTemp);
        }
        if ((sTemp = this.getParameter("color6")) != null) {
            Game.colorBlocks[6] = this.parseColor(sTemp);
        }
        if ((sTemp = this.getParameter("color7")) != null) {
            Game.colorBlocks[7] = this.parseColor(sTemp);
        }
    }

    private Color parseColor(String s) {
        int[] nHexDigits = new int[6];
        if (s.length() != 7) {
            return Color.white;
        }
        int cntr = 0;
        while (cntr < 6) {
            char nUCValue = Character.toUpperCase(s.charAt(cntr + 1));
            if (nUCValue >= '0' && nUCValue <= '9') {
                nHexDigits[cntr] = nUCValue - 48;
            }
            if (nUCValue >= 'A' && nUCValue <= 'F') {
                nHexDigits[cntr] = nUCValue - 55;
            }
            ++cntr;
        }
        return new Color(nHexDigits[0] * 16 + nHexDigits[1], nHexDigits[2] * 16 + nHexDigits[3], nHexDigits[4] * 16 + nHexDigits[5]);
    }

    public void mouseBtnUp(int x, int y) {
        if (this.nMode == 2) {
            this.nMode = 1;
            int nLvlID = this.panelGame.getNextLevel();
            if (nLvlID > -1) {
                this.panelGame.setLevel(this, nLvlID);
                ((CardLayout)this.getLayout()).show(this, "game");
            } else {
                ((CardLayout)this.getLayout()).show(this, "menu");
            }
        } else {
            this.panelGame.mouseBtnUp(x, y);
        }
    }

    public void start() {
        if (this.runner == null) {
            this.runner = new Thread(this);
            this.runner.start();
        }
    }

    public void run() {
        this.threadAlive = true;
        while (this.threadAlive) {
            if (this.nMode == 1) {
                this.panelGame.clockTick();
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void stop() {
        if (this.runner != null) {
            this.threadAlive = false;
            this.runner = null;
        }
    }

    public void destroy() {
        if (this.runner != null) {
            this.threadAlive = false;
            this.runner = null;
        }
        super.destroy();
    }

    public void actionPerformed(ActionEvent e) {
        int nLvlID;
        String sID = e.getActionCommand();
        if (sID.equals("Easy")) {
            this.panelGame.setLevel(this, 0);
            this.nMode = 1;
            ((CardLayout)this.getLayout()).show(this, "game");
        }
        if (sID.equals("Normal")) {
            this.panelGame.setLevel(this, this._normalStart);
            this.nMode = 1;
            ((CardLayout)this.getLayout()).show(this, "game");
        }
        if (sID.equals("Hard")) {
            this.panelGame.setLevel(this, this._hardStart);
            this.nMode = 1;
            ((CardLayout)this.getLayout()).show(this, "game");
        }
        if (sID.equals("Use Password") && (nLvlID = this.checkPassword(this.panelMenu.getPWText())) > -1) {
            this.panelGame.setLevel(this, nLvlID);
            this.nMode = 1;
            ((CardLayout)this.getLayout()).show(this, "game");
        }
        if (sID.equals("QUIT")) {
            this.nMode = 0;
            ((CardLayout)this.getLayout()).show(this, "menu");
        }
        if (sID.equals("LEVEL DONE")) {
            this.nMode = 2;
            nLvlID = this.panelGame.getNextLevel();
            if (nLvlID > -1) {
                this.panelMessage.setPassword(this.getPassword(nLvlID));
                this.panelMessage.setComplete(false);
            } else {
                this.panelMessage.setComplete(true);
            }
            ((CardLayout)this.getLayout()).show(this, "message");
        }
    }

    public String getAppletInfo() {
        return "Color Collapse V2.00. Copyright 1998,2002 Spelchan Software";
    }

    private void loadConfig() {
        URL url;
        String s = this.getParameter("CONFIG");
        if (s == null) {
            this.errorMessage = "Missing properties";
            this.errorOccured = true;
            return;
        }
        try {
            url = new URL(this.getCodeBase(), s);
        }
        catch (MalformedURLException mue) {
            this.errorMessage = "Invalid URL specified for config";
            this.errorOccured = true;
            return;
        }
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
            String temp = in.readLine();
            do {
                int index;
                if ((index = temp.indexOf(32)) <= 2) continue;
                String command = temp.substring(0, index);
                String param = temp.substring(index + 1);
                this._config.put(command, param);
            } while ((temp = in.readLine()) != null);
            in.close();
        }
        catch (IOException ioe) {
            this.errorMessage = "IO Exception reading config";
            this.errorOccured = true;
            return;
        }
    }

    public String[] parseString(String s, char ch) {
        int count = 0;
        int len = s.length();
        int cntr = 0;
        while (cntr < len) {
            char sc = s.charAt(cntr);
            if (sc == ch) {
                ++count;
            }
            ++cntr;
        }
        String[] rs = new String[count + 1];
        int start = 0;
        int last = 0;
        cntr = 0;
        while (cntr < count) {
            last = s.indexOf(ch, start);
            rs[cntr] = s.substring(start, last);
            start = last + 1;
            ++cntr;
        }
        rs[count] = s.substring(start);
        return rs;
    }

    public int parseInt(String s, int d) {
        int r;
        try {
            r = Integer.parseInt(s);
        }
        catch (Exception e) {
            r = d;
        }
        return r;
    }

    public Rectangle parseRect(String s) {
        String[] args = this.parseString(s, ',');
        if (args == null || args.length != 4) {
            return new Rectangle(0, 0, 0, 0);
        }
        int x = this.parseInt(args[0], 0);
        int y = this.parseInt(args[1], 0);
        int w = this.parseInt(args[2], 0);
        int h = this.parseInt(args[3], 0);
        return new Rectangle(x, y, w, h);
    }

    public void showError(String s) {
        this.panelError.setMessage(s);
        ((CardLayout)this.getLayout()).show(this, "error");
        this.repaint();
    }

    public int checkPassword(String pw) {
        int nRet = -1;
        int numLevels = this.parseInt((String)this._config.get(NUMLEVELS), 0);
        int cntr = 0;
        while (cntr < numLevels) {
            String s = (String)this._config.get("PW[" + cntr + "]");
            if (s != null && s.equalsIgnoreCase(pw)) {
                nRet = cntr;
            }
            ++cntr;
        }
        return nRet;
    }

    public String getPassword(int nID) {
        return (String)this._config.get("PW[" + nID + "]");
    }
}

