/*
 * Decompiled with CFR 0.152.
 */
package com.blazinggames.cc;

import com.blazinggames.cc.Collapse;
import com.blazinggames.cc.Collapse_MouseAdapter;
import com.blazinggames.cc.Grid;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class Game
extends Panel {
    private static final long serialVersionUID = 6767030100L;
    static Color[] colorBlocks = new Color[]{Color.black, Color.red, Color.yellow, Color.green, Color.blue, new Color(128, 0, 128), new Color(0, 255, 255), Color.magenta};
    static Font fontNorm = new Font("TimesRoman", 0, 12);
    static Font fontScore = new Font("TimesRoman", 0, 24);
    static final int BLOCKFULLSIZE = 22;
    static final int BLOCKSIZE = 20;
    static final int BLOCKGAP = 1;
    static final int PLAYFIELDX = 20;
    static final int PLAYFIELDY = 20;
    static final int PLAYFIELDHEIGHT = 20;
    static final int PLAYFIELDBOTTOM = 460;
    static final int PLAYFIELDRIGHT = 460;
    static final int BUTTONBARX = 480;
    static final int BUTTONWIDTH = 150;
    static final int BUTTONHEIGHT = 50;
    static final int BTNRESETY = 80;
    static final int BTNQUITY = 380;
    static final int SCOREY = 200;
    ActionListener eventActionListener;
    Grid clpsGrid;
    int[] nColumnTops = new int[20];
    int[] nColumnGaps = new int[20];
    int nCurrentScreen;
    int nOldScreen;
    boolean bFullUpdate;
    boolean bBlocksFalling;
    int nFrameCount;
    int nBlockFrame;
    int nCurrentLevel;
    int nNormalStart;
    int nHighStart;
    int nNumLevels;

    Game(Collapse_MouseAdapter mouseAdapter, ActionListener al, int norm, int high, int numLevels) {
        this.eventActionListener = al;
        this.addMouseListener(mouseAdapter);
        this.clpsGrid = new Grid();
        this.bFullUpdate = true;
        this.bBlocksFalling = false;
        this.nNormalStart = norm;
        this.nHighStart = high;
        this.nNumLevels = numLevels;
        this.setBackground(Color.white);
    }

    public void setLevel(Collapse a, int nID) {
        String s = (String)a._config.get("LEVEL[" + nID + "]");
        try {
            URL host = new URL(a.getCodeBase(), s);
            DataInputStream iFile = new DataInputStream(host.openStream());
            this.clpsGrid.readFile(iFile);
            iFile.close();
        }
        catch (MalformedURLException me) {
            System.out.println("URL Error");
        }
        catch (IOException e) {
            System.out.println("IO Error");
        }
        this.nCurrentLevel = nID;
        this.bFullUpdate = true;
        this.bBlocksFalling = false;
    }

    public int getNextLevel() {
        int nextLevel = this.nCurrentLevel + 1;
        if (nextLevel == this.nNormalStart || nextLevel == this.nHighStart || nextLevel == this.nNumLevels) {
            return -1;
        }
        return nextLevel;
    }

    public void clockTick() {
        if (this.bBlocksFalling) {
            this.nFrameCount += 4;
            this.repaint();
        }
    }

    public void paint(Graphics g) {
        if (this.bFullUpdate) {
            g.setColor(colorBlocks[0]);
            g.fillRect(20, 20, 440, 440);
            this.bFullUpdate = false;
        }
        int cntrR = 0;
        while (cntrR < 20) {
            int cntrC = 0;
            while (cntrC < 20) {
                int nBlockColor = this.clpsGrid.getBlock(cntrC, cntrR);
                g.setColor(colorBlocks[nBlockColor]);
                g.fillRect(cntrC * 22 + 1 + 20, (20 - cntrR - 1) * 22 + 1 + 20, 20, 20);
                g.setColor(Color.black);
                g.drawRect(cntrC * 22 + 20, (20 - cntrR - 1) * 22 + 20, 21, 21);
                ++cntrC;
            }
            ++cntrR;
        }
        g.setColor(Color.gray);
        g.draw3DRect(480, 80, 150, 50, true);
        g.draw3DRect(481, 81, 148, 48, true);
        g.draw3DRect(480, 380, 150, 50, true);
        g.draw3DRect(481, 381, 148, 48, true);
        g.setColor(Color.black);
        g.setFont(fontNorm);
        FontMetrics fm = g.getFontMetrics();
        int nTextWidth = fm.stringWidth("RESET");
        g.drawString("RESET", 480 + (150 - nTextWidth) / 2, 120);
        nTextWidth = fm.stringWidth("QUIT");
        g.drawString("QUIT", 480 + (150 - nTextWidth) / 2, 420);
        g.setColor(Color.white);
        g.fillRect(480, 200, 150, 50);
        g.setColor(Color.blue);
        g.setFont(fontScore);
        fm = g.getFontMetrics();
        String sScore = String.valueOf(this.clpsGrid.countBlocks());
        nTextWidth = fm.stringWidth(sScore);
        g.drawString(sScore, 480, 245);
        this.doCollapse();
    }

    public void mouseBtnUp(int x, int y) {
        if (!this.bBlocksFalling) {
            if (x > 480) {
                if (y > 80 && y < 130) {
                    this.clpsGrid.refreshGrid();
                    this.bFullUpdate = true;
                    this.repaint();
                } else if (y > 380 & y < 430) {
                    this.eventActionListener.actionPerformed(new ActionEvent(this, 1001, "QUIT"));
                }
            } else if (x >= 20 && y >= 20 && y < 460 && x < 460) {
                this.clpsGrid.removeChain((x - 20) / 22, 20 - (y - 20) / 22 - 1);
                if (this.clpsGrid.countBlocks() == 0) {
                    this.eventActionListener.actionPerformed(new ActionEvent(this, 1001, "LEVEL DONE"));
                } else {
                    this.repaint();
                }
            }
        }
    }

    public void update(Graphics g) {
        if (this.bBlocksFalling) {
            this.updateCollapse(g);
        } else {
            this.paint(g);
        }
    }

    void doCollapse() {
        int nNumFalling = 0;
        this.bBlocksFalling = false;
        this.nBlockFrame = 0;
        this.nFrameCount = 0;
        int cntrC = 0;
        while (cntrC < 20) {
            this.nColumnTops[cntrC] = this.clpsGrid.getTopBlock(cntrC);
            this.nColumnGaps[cntrC] = this.clpsGrid.collapseColumn(cntrC);
            nNumFalling += this.nColumnGaps[cntrC];
            ++cntrC;
        }
        if (nNumFalling > 0) {
            this.bBlocksFalling = true;
        }
    }

    void updateCollapse(Graphics g) {
        if (this.nFrameCount > 22) {
            this.nFrameCount = 22;
        }
        int nGap = this.nFrameCount - this.nBlockFrame;
        int cntrC = 0;
        while (cntrC < 20) {
            if (this.nColumnGaps[cntrC] > 0) {
                int nSX = cntrC * 22 + 20;
                int nSY = (20 - this.nColumnTops[cntrC] - 1) * 22 + 20 + this.nBlockFrame;
                int nSY2 = (1 + this.nColumnTops[cntrC] - this.nColumnGaps[cntrC]) * 22;
                g.copyArea(nSX, nSY, 22, nSY2, 0, nGap);
                g.setColor(Color.black);
                g.fillRect(nSX, nSY, 22, nGap);
            }
            ++cntrC;
        }
        this.nBlockFrame = this.nFrameCount;
        if (this.nFrameCount == 22) {
            this.doCollapse();
        }
    }
}

