/*
 * Decompiled with CFR 0.152.
 */
package com.blazinggames.cc;

import java.io.DataInputStream;
import java.io.IOException;

class Grid {
    public static final int clpsNUMCOLS = 20;
    public static final int clpsNUMROWS = 20;
    byte[][] m_nGrid = new byte[20][20];
    byte[][] m_nRefresh = new byte[20][20];

    Grid() {
        this.clear();
    }

    void clear() {
        int cntrC = 0;
        while (cntrC < 20) {
            int cntrR = 0;
            while (cntrR < 20) {
                this.m_nGrid[cntrC][cntrR] = 0;
                this.m_nRefresh[cntrC][cntrR] = 0;
                ++cntrR;
            }
            ++cntrC;
        }
    }

    void storeGrid() {
        int cntrC = 0;
        while (cntrC < 20) {
            int cntrR = 0;
            while (cntrR < 20) {
                this.m_nRefresh[cntrC][cntrR] = this.m_nGrid[cntrC][cntrR];
                ++cntrR;
            }
            ++cntrC;
        }
    }

    void refreshGrid() {
        int cntrC = 0;
        while (cntrC < 20) {
            int cntrR = 0;
            while (cntrR < 20) {
                this.m_nGrid[cntrC][cntrR] = this.m_nRefresh[cntrC][cntrR];
                ++cntrR;
            }
            ++cntrC;
        }
    }

    void fullCollapse() {
        int nIsFalling;
        do {
            nIsFalling = 0;
            int cntrC = 0;
            while (cntrC < 20) {
                nIsFalling += this.collapseColumn(cntrC);
                ++cntrC;
            }
        } while (nIsFalling > 0);
    }

    void removeBlock(int nCol, int nRow) {
        if (this.m_nGrid[nCol][nRow] == 0) {
            return;
        }
        byte nBlock = this.m_nGrid[nCol][nRow];
        this.m_nGrid[nCol][nRow] = 0;
        if (nRow < 19 && this.m_nGrid[nCol][nRow + 1] == nBlock) {
            this.removeBlock(nCol, nRow + 1);
        }
        if (nRow > 0 && this.m_nGrid[nCol][nRow - 1] == nBlock) {
            this.removeBlock(nCol, nRow - 1);
        }
        if (nCol < 19 && this.m_nGrid[nCol + 1][nRow] == nBlock) {
            this.removeBlock(nCol + 1, nRow);
        }
        if (nCol > 0 && this.m_nGrid[nCol - 1][nRow] == nBlock) {
            this.removeBlock(nCol - 1, nRow);
        }
    }

    int removeChain(int nCol, int nRow) {
        int nIsChain = 0;
        if (this.m_nGrid[nCol][nRow] == 0) {
            return 0;
        }
        byte nBlock = this.m_nGrid[nCol][nRow];
        if (nRow < 19 && this.m_nGrid[nCol][nRow + 1] == nBlock) {
            nIsChain = 1;
        }
        if (nRow > 0 && this.m_nGrid[nCol][nRow - 1] == nBlock) {
            nIsChain = 1;
        }
        if (nCol < 19 && this.m_nGrid[nCol + 1][nRow] == nBlock) {
            nIsChain = 1;
        }
        if (nCol > 0 && this.m_nGrid[nCol - 1][nRow] == nBlock) {
            nIsChain = 1;
        }
        if (nIsChain > 0) {
            this.removeBlock(nCol, nRow);
        }
        return nIsChain;
    }

    int collapseColumn(int nCol) {
        boolean nInGap = false;
        int nDangle = 0;
        int cntrR = 0;
        while (cntrR < 20) {
            if (this.m_nGrid[nCol][cntrR] == 0) {
                nInGap = true;
            } else if (nInGap) {
                nDangle = cntrR;
                break;
            }
            ++cntrR;
        }
        if (nDangle > 0) {
            cntrR = nDangle;
            while (cntrR < 20) {
                this.m_nGrid[nCol][cntrR - 1] = this.m_nGrid[nCol][cntrR];
                ++cntrR;
            }
            this.m_nGrid[nCol][19] = 0;
        }
        return nDangle;
    }

    int getTopBlock(int nCol) {
        int nTop = 0;
        int cntrR = 0;
        while (cntrR < 20) {
            if (this.m_nGrid[nCol][cntrR] > 0) {
                nTop = cntrR;
            }
            ++cntrR;
        }
        return nTop;
    }

    int countBlocks() {
        int nCount = 0;
        int cntrC = 0;
        while (cntrC < 20) {
            int cntrR = 0;
            while (cntrR < 20) {
                if (this.m_nGrid[cntrC][cntrR] > 0) {
                    ++nCount;
                }
                ++cntrR;
            }
            ++cntrC;
        }
        return nCount;
    }

    int getBlock(int nCol, int nRow) {
        return this.m_nGrid[nCol][nRow];
    }

    void readFile(DataInputStream iFile) {
        try {
            int cntrC = 0;
            while (cntrC < 20) {
                int cntrR = 0;
                while (cntrR < 20) {
                    this.m_nGrid[cntrC][cntrR] = iFile.readByte();
                    ++cntrR;
                }
                ++cntrC;
            }
        }
        catch (IOException e) {
            System.out.println("IO Error");
        }
        this.storeGrid();
    }
}

