/*
 * Color Collapse
 * Copyright (c) 1998, 2002, 2004-2006 Blazing Games Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package com.blazinggames.cc;

import java.applet.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.net.*;
import java.util.Hashtable;

/**
 * Color Collapse applet
 * 
 * @author Billy D. Spelchan
 * @version 1.0 OSR
 */
public class Collapse 
extends Applet 
implements Runnable, ActionListener {
// *** CONSTANTS ***
	private static final long serialVersionUID = 6767010100L;
	
	// Parameters
    private static final String NUMLEVELS = "NUMLEVELS";
    private static final String PASS = "PW";
    private static final String NORMALSTART = "NORMALSTART";
    private static final String HARDSTART = "HARDSTART";
    static final int MENU = 0;
	static final int GAME = 1;
	static final int MESSAGE = 2;
// *** VARIABLES ***
	Menu panelMenu;
	Game panelGame;
	Message panelMessage;
    ErrorMessage panelError;
    
	Thread runner;
	boolean threadAlive = true;
	boolean bAnimInAction;
	int nMode;
	int nFrameCount;
	Collapse_MouseAdapter mouseAdapter;

    private String errorMessage;
    private boolean errorOccured = false;
    public Hashtable _config = new Hashtable();

    int _normalStart;
    int _hardStart;
    
// *********************************
// ***** METHODS - From Applet *****
// *********************************
    
	public void init()
    {
		setLayout(new CardLayout());
        panelError = new ErrorMessage("Unknown error");
        add("error", panelError);
        loadConfig();
        if (errorOccured)
        {
            showError(errorMessage);
            return;
        }
		mouseAdapter = new Collapse_MouseAdapter(this);
		this.addMouseListener(mouseAdapter);
		panelMenu = new Menu(this);
        _normalStart = parseInt((String)_config.get(NORMALSTART), 4);
        _hardStart = parseInt((String)_config.get(HARDSTART), 8);
        int num = parseInt((String)_config.get(NUMLEVELS), 12);        
		panelGame = new Game(mouseAdapter, this, _normalStart, _hardStart, num);
		panelGame.setLevel(this, 0);
		panelMessage = new Message(this);
		panelMessage.addMouseListener(mouseAdapter);
		add("menu", panelMenu);
		add("game", panelGame);
		add("message", panelMessage);
        ((CardLayout)getLayout()).show(this,"menu");
		requestFocus();
		nMode = MENU;
        setBlockColors();
        repaint();
	}

  private void setBlockColors() {
    String sTemp;

    System.out.println("Analyzing parameters");
    sTemp = getParameter("color1");
    if (sTemp != null){
      System.out.println("Setting color 1");
      Game.colorBlocks[1] = parseColor(sTemp);
    }
    sTemp = getParameter("color2");
    if (sTemp != null)
      Game.colorBlocks[2] = parseColor(sTemp);
    sTemp = getParameter("color3");
    if (sTemp != null)
      Game.colorBlocks[3] = parseColor(sTemp);
    sTemp = getParameter("color4");
    if (sTemp != null)
      Game.colorBlocks[4] = parseColor(sTemp);
    sTemp = getParameter("color5");
    if (sTemp != null)
      Game.colorBlocks[5] = parseColor(sTemp);
    sTemp = getParameter("color6");
    if (sTemp != null)
      Game.colorBlocks[6] = parseColor(sTemp);
    sTemp = getParameter("color7");
    if (sTemp != null)
      Game.colorBlocks[7] = parseColor(sTemp);
  }

  private Color parseColor(String s) {
    int cntr, nUCValue;
    int nHexDigits[] = new int[6];

    if (s.length() != 7)
      return Color.white;
    for (cntr = 0; cntr < 6; ++cntr) {
      nUCValue = (int)(Character.toUpperCase(s.charAt(cntr+1)));
      if ((nUCValue >= 48) && (nUCValue <= 57))
        nHexDigits[cntr] = nUCValue - 48;
      if ((nUCValue >= 65) && (nUCValue <= 70))
        nHexDigits[cntr] = nUCValue - 55;
    }

    return new Color(nHexDigits[0]*16+nHexDigits[1],nHexDigits[2]*16+nHexDigits[3],nHexDigits[4]*16+nHexDigits[5]);
  }

	public void mouseBtnUp(int x, int y) {
		if (nMode == MESSAGE) {
			nMode = GAME;
			int nLvlID = panelGame.getNextLevel();
			if (nLvlID > -1) {
				panelGame.setLevel(this,nLvlID);
				((CardLayout)getLayout()).show(this,"game");
			}
			else
				((CardLayout)getLayout()).show(this,"menu");
		}
		else
			panelGame.mouseBtnUp(x,y);
	}


	public void start() {
		if (runner == null) {
			runner = new Thread(this);
			runner.start();
		}
	}

	public void run() {
		threadAlive = true;
		while (threadAlive) {
			if (nMode == GAME) {
				panelGame.clockTick();
			}
      try { Thread.sleep(100); }
      catch (InterruptedException e) { }
		}
	}

	public void stop() {
		if (runner != null) {
			threadAlive = false;
			runner = null;
		}
	}

	public void destroy() {
		if (runner != null) {
			threadAlive = false;
			runner = null;
		}
    super.destroy();
	}

	public void actionPerformed(ActionEvent e) {
		int nLvlID;
		String sID = e.getActionCommand();

		if (sID.equals("Easy"))
        {
			panelGame.setLevel(this,0);
			nMode = GAME;
			((CardLayout)getLayout()).show(this,"game");
		}
		if (sID.equals("Normal"))
        {
			panelGame.setLevel(this,_normalStart);
			nMode = GAME;
			((CardLayout)getLayout()).show(this,"game");
		}
		if (sID.equals("Hard"))
        {
			panelGame.setLevel(this,_hardStart);
			nMode = GAME;
			((CardLayout)getLayout()).show(this,"game");
		}
		if (sID.equals("Use Password")) {
			nLvlID = checkPassword(panelMenu.getPWText());
			if (nLvlID > -1) {
				panelGame.setLevel(this, nLvlID);
				nMode = GAME;
				((CardLayout)getLayout()).show(this,"game");
			}
		}
		if (sID.equals("QUIT")) {
			nMode = MENU;
			((CardLayout)getLayout()).show(this,"menu");
		}
		if (sID.equals("LEVEL DONE")) {
			nMode = MESSAGE;
			nLvlID = panelGame.getNextLevel();
			if (nLvlID > -1) {
				panelMessage.setPassword(getPassword(nLvlID));
				panelMessage.setComplete(false);
			}
			else
				panelMessage.setComplete(true);
			((CardLayout)getLayout()).show(this,"message");
		}
	}

	public String getAppletInfo() {
    	return "Color Collapse V2.00. Copyright 1998,2002 Spelchan Software";
	}

    // *************************************************
    // ***** METHODS - Configuration File Handling *****
    // *************************************************

    private void loadConfig()
    {
        String s = getParameter("CONFIG");
        if (s == null)
        {
            errorMessage = "Missing properties";
            errorOccured = true;
            return;
        }
        URL url;
        try
        {
            url = new URL(getCodeBase(), s);
        }
        catch (MalformedURLException mue)
        {
            errorMessage = "Invalid URL specified for config";
            errorOccured = true;
            return;
        }

        String temp;
        String command, param;
        int index;
        BufferedReader in;

        try
        {
            in = new BufferedReader(new InputStreamReader(url.openStream()));
            temp = in.readLine();
            do
            {
                //System.out.println(temp);
                index = temp.indexOf(' ');
                if (index > 2) // must have 3 characters before space
                {
                    command = temp.substring(0, index);
                    param = temp.substring(index+1);
//System.out.println("CMD=" + command + " param=" + param);
                    _config.put(command, param);
                }
                temp = in.readLine();
            }
            while (temp != null);
            in.close();
        }
        catch (IOException ioe)
        {
            errorMessage = "IO Exception reading config";
            errorOccured = true;
            return;
        }
    }

    public String[] parseString(String s, char ch)
    {
        int cntr, count = 0;
        int len = s.length();
        char sc;

        for (cntr = 0; cntr < len; ++cntr)
        {
            sc = s.charAt(cntr);
            if (sc == ch)
                ++count;
        }

        String rs[] = new String[count+1];
        int start = 0;
        int last = 0;
        for (cntr = 0; cntr < count; ++cntr)
        {
            last = s.indexOf(ch, start);
            rs[cntr] = s.substring(start, last);
            start = last + 1;
        }
        rs[count] = s.substring(start);

        return rs;
    }

    public int parseInt(String s, int d)
    {
        int r;

        try
        {
            r = Integer.parseInt(s);
        }
        catch (Exception e)
        {
            r = d;
        }

        return r;
    }

    public Rectangle parseRect(String s)
    {
        String args[] = parseString(s, ',');
        if ( (args == null) || (args.length != 4) )
        {
            return new Rectangle(0,0,0,0);
        }
        int x = parseInt(args[0], 0);
        int y = parseInt(args[1], 0);
        int w = parseInt(args[2], 0);
        int h = parseInt(args[3], 0);
        return new Rectangle(x, y, w, h);
    }

// ***** METHODS - Error handling *****

    public void showError(String s)
    {
        panelError.setMessage(s);
        ((CardLayout)getLayout()).show(this,"error");
        repaint();
    }

// ***** METHODS - Password handling *****
    // Goes through the password list returning level of password (-1=none)
    public int checkPassword(String pw)
    {
        String s;
        
        int cntr, nRet = -1;
        int numLevels = parseInt((String)_config.get(NUMLEVELS), 0);
        for (cntr = 0; cntr < numLevels; ++cntr)
        {
            s = (String)_config.get(PASS + "[" + cntr + "]");
            if ( (s != null) && (s.equalsIgnoreCase(pw)) )
                nRet = cntr;
        }
        
        return nRet;
    }

    public String getPassword(int nID) {
        return (String)_config.get(PASS + "[" + nID + "]");
    }
    
}

//====================================================================

class Collapse_MouseAdapter extends java.awt.event.MouseAdapter {
	Collapse adaptee;

	Collapse_MouseAdapter(Collapse c) {
		adaptee = c;
	}

	public void mouseReleased(MouseEvent e) {
		adaptee.mouseBtnUp(e.getX(), e.getY());
	}
}

