/*
 * Color Collapse
 * Copyright (c) 1998, 2002, 2004-2006 Blazing Games Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package com.blazinggames.cc;

import java.awt.*;

/**
 * If there are problems, this reports the problems to the user so that they
 * can (in theory, though rarely in practice) report the problem to the webmaster.
 * 
 * @author Billy D. Spelchan
 * @version 1.0 OSR
 */
public class ErrorMessage
extends Panel
{
// *********************
// ***** CONSTANTS *****
// *********************
	private static final long serialVersionUID = 6767040100L;
	
    private static final int ERROR_X = 80;
    private static final int ERROR_Y = 100;
    private static final String ERROR_TEXT = "AN ERROR OCCURRED:";
    private static final Color ERROR_COLOR = Color.white;
    private static final Font ERROR_FONT = new Font ("Serif", Font.BOLD, 48);
    
    private static final int MESSAGE_Y = 250;
    private static final int MESSAGE_X = 80;
    private static final Font MESSAGE_FONT = new Font("Serif", Font.PLAIN, 32);
    private static final Color MESSAGE_COLOR = Color.yellow;


// *********************
// ***** VARIABLES *****
// *********************

    private String _message;

// ***********************
// ***** CONSTRUCTOR *****
// ***********************
    
    ErrorMessage(String s)
    {
        super();
        _message = s;
        setBackground(Color.black);
    }

// ***************************************
// ***** METHODS - Parameter setting *****
// ***************************************
    
    // Set the password for the next level
    public void setMessage(String s)
    {
        _message = s;
    }

// ******************************
// ***** METHODS - PAINTING *****
// ******************************
    
    public void paint(Graphics g)
    {
        g.setFont(ERROR_FONT);
        g.setColor(ERROR_COLOR);
        g.drawString(ERROR_TEXT, ERROR_X, ERROR_Y);
        g.setFont(MESSAGE_FONT);
        g.setColor(MESSAGE_COLOR);
        g.drawString(_message, MESSAGE_X, MESSAGE_Y);        
    }
    
}
