/*
 * Color Collapse
 * Copyright (c) 1998, 2002, 2004-2006 Blazing Games Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package com.blazinggames.cc;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.net.*;

/**
 * From the title of this class, one should have already figured out that
 * this is what runs the actual color collapse game!
 * 
 * @author Billy D. Spelchan
 * @version 1.0 OSR
 */
public class Game
extends Panel
{

// *** CONSTANTS ***
	private static final long serialVersionUID = 6767030100L;
/*
    static String sLevelNames[] = {
				"gotm/collapse/easy1.clv","gotm/collapse/easy2.clv",
				"gotm/collapse/easy3.clv", "gotm/collapse/easy4.clv",
				"gotm/collapse/norm1.clv","gotm/collapse/norm2.clv",
				"gotm/collapse/norm3.clv", "gotm/collapse/norm4.clv",
				"gotm/collapse/hard1.clv","gotm/collapse/hard2.clv",
				"gotm/collapse/hard3.clv", "gotm/collapse/hard4.clv" };
*/
    
	static Color colorBlocks[] = {Color.black, Color.red, Color.yellow,
				Color.green, Color.blue, new Color(128,0,128),
				new Color(0,255,255), Color.magenta };
			// Color Table
	static Font fontNorm = new Font("TimesRoman", Font.PLAIN, 12);
	static Font fontScore = new Font("TimesRoman", Font.PLAIN, 24);
			// Fonts
	static final int BLOCKFULLSIZE = 22;
	static final int BLOCKSIZE = 20;
	static final int BLOCKGAP = (BLOCKFULLSIZE - BLOCKSIZE) / 2;
			// Size and spacing of game blocks
	static final int PLAYFIELDX = 20;
	static final int PLAYFIELDY = 20;
	static final int PLAYFIELDHEIGHT = 20;
	static final int PLAYFIELDBOTTOM = PLAYFIELDHEIGHT * BLOCKFULLSIZE + PLAYFIELDY;
	static final int PLAYFIELDRIGHT = PLAYFIELDHEIGHT * BLOCKFULLSIZE + PLAYFIELDX;
			// Offset information for playfield
	static final int BUTTONBARX = 480;
	static final int BUTTONWIDTH = 150;
	static final int BUTTONHEIGHT = 50;
	static final int BTNRESETY = 80;
	static final int BTNQUITY = 380;
	static final int SCOREY = 200;

// *********************
// ***** VARIABLES *****
// *********************
    
    // Listener to action events
	ActionListener eventActionListener;
    // Game Grid
	Grid clpsGrid;
	int nColumnTops[] = new int[PLAYFIELDHEIGHT];
	int nColumnGaps[] = new int[PLAYFIELDHEIGHT];

	int nCurrentScreen, nOldScreen;
	boolean bFullUpdate;

    // Animation handling variables
	boolean bBlocksFalling;
	int nFrameCount, nBlockFrame;

    int nCurrentLevel;
    int nNormalStart;
    int nHighStart;
    int nNumLevels;
    
// ***********************
// ***** CONSTRUCTOR *****
// ***********************
    
	Game(Collapse_MouseAdapter mouseAdapter, ActionListener al, int norm, int high, int numLevels)
    {
		eventActionListener = al;
		this.addMouseListener(mouseAdapter);
		clpsGrid = new Grid();
		bFullUpdate = true;
		bBlocksFalling = false;

    	nNormalStart = norm;
    	nHighStart = high;
        nNumLevels = numLevels;
		this.setBackground(Color.white);
	}

// ***
	public void setLevel(Collapse a, int nID)
    {
        String s = (String)a._config.get("LEVEL[" + nID + "]");
		try {
			URL host = new URL(a.getCodeBase(), s);
			DataInputStream iFile = new DataInputStream(host.openStream());
			clpsGrid.readFile(iFile);
			iFile.close();
		} catch (MalformedURLException me) {
			System.out.println("URL Error");
		} catch (IOException e) {
			System.out.println("IO Error");
		}
		nCurrentLevel = nID;
		bFullUpdate = true;
		bBlocksFalling = false;
	}

	public int getNextLevel() {
        int nextLevel = nCurrentLevel + 1;
        if ( (nextLevel == nNormalStart) || (nextLevel == nHighStart) || (nextLevel == nNumLevels) )
            return -1;
        else
            return nextLevel;
	}

	public void clockTick() {
		if (bBlocksFalling) {
			nFrameCount += 4;
			repaint();
		}
	}

	public void paint(Graphics g) {
		int cntrR, cntrC, nBlockColor, nTextWidth;
		String sScore;

		if (bFullUpdate) {
			g.setColor(colorBlocks[0]);
			g.fillRect(PLAYFIELDX,PLAYFIELDY,
						Grid.clpsNUMCOLS * BLOCKFULLSIZE,
						Grid.clpsNUMROWS * BLOCKFULLSIZE);
			bFullUpdate = false;
		}
		for (cntrR = 0; cntrR < Grid.clpsNUMROWS; ++cntrR)
			for (cntrC = 0; cntrC < Grid.clpsNUMCOLS; ++cntrC) {
				nBlockColor = clpsGrid.getBlock(cntrC, cntrR);
				g.setColor(colorBlocks[nBlockColor]);
				g.fillRect(cntrC * BLOCKFULLSIZE + BLOCKGAP + PLAYFIELDX,
							(Grid.clpsNUMROWS - cntrR - 1) * BLOCKFULLSIZE +
							BLOCKGAP + PLAYFIELDY, BLOCKSIZE, BLOCKSIZE);
				g.setColor(Color.black);
				g.drawRect(cntrC * BLOCKFULLSIZE + PLAYFIELDX,
							(Grid.clpsNUMROWS - cntrR - 1) * BLOCKFULLSIZE +
							PLAYFIELDY, BLOCKFULLSIZE-1, BLOCKFULLSIZE-1);
			}
		// paint button bar
		g.setColor(Color.gray);
		g.draw3DRect(BUTTONBARX, BTNRESETY, BUTTONWIDTH, BUTTONHEIGHT, true);
		g.draw3DRect(BUTTONBARX+1, BTNRESETY+1, BUTTONWIDTH-2, BUTTONHEIGHT-2, true);
		g.draw3DRect(BUTTONBARX, BTNQUITY, BUTTONWIDTH, BUTTONHEIGHT, true);
		g.draw3DRect(BUTTONBARX+1, BTNQUITY+1, BUTTONWIDTH-2, BUTTONHEIGHT-2, true);
		g.setColor(Color.black);
		g.setFont(fontNorm);
		FontMetrics fm = g.getFontMetrics();
		nTextWidth = fm.stringWidth("RESET");
		g.drawString("RESET", BUTTONBARX+(BUTTONWIDTH-nTextWidth)/2, BTNRESETY+BUTTONHEIGHT-10);
		nTextWidth = fm.stringWidth("QUIT");
		g.drawString("QUIT", BUTTONBARX+(BUTTONWIDTH-nTextWidth)/2, BTNQUITY+BUTTONHEIGHT-10);
		g.setColor(Color.white);
		g.fillRect(BUTTONBARX,SCOREY, BUTTONWIDTH, BUTTONHEIGHT);
		g.setColor(Color.blue);
		g.setFont(fontScore);
		fm = g.getFontMetrics();
		sScore = String.valueOf(clpsGrid.countBlocks());
		nTextWidth = fm.stringWidth(sScore);
		g.drawString(sScore, BUTTONBARX, SCOREY+BUTTONHEIGHT-5);

		doCollapse();
	}

	public void mouseBtnUp(int x, int y) {
//	if ( (m_bAreBlocksFalling == 0) && (m_bGameWon == 0) ) {
		if (!bBlocksFalling) {
			if (x > BUTTONBARX)
            { // if in bottom area
                if ( (y > BTNRESETY) && (y < (BTNRESETY + BUTTONHEIGHT)) )
                {
                    clpsGrid.refreshGrid();
                    bFullUpdate = true;
                    repaint();                    
                }
                else if ( (y > BTNQUITY) & (y < (BTNQUITY + BUTTONHEIGHT)) )
                {
                    eventActionListener.actionPerformed(new ActionEvent(this, ActionEvent.ACTION_PERFORMED, "QUIT"));
                }
			}
			else
            {
				if ( (x >= PLAYFIELDX) && (y >= PLAYFIELDY) &&
							(y < PLAYFIELDBOTTOM) && (x < PLAYFIELDRIGHT) ) {
					clpsGrid.removeChain((x-PLAYFIELDX) / BLOCKFULLSIZE,
								PLAYFIELDHEIGHT-((y-PLAYFIELDY)/BLOCKFULLSIZE)-1);
	//				clpsGrid.fullCollapse();
	//				doCollapse();
					if (clpsGrid.countBlocks() == 0)
						eventActionListener.actionPerformed(new ActionEvent(this, ActionEvent.ACTION_PERFORMED, "LEVEL DONE"));
					else
						repaint();
				}
			}
		}
	}

	public void update(Graphics g)
    {
		if (bBlocksFalling)
			updateCollapse(g);
		else
			paint(g);
	}

	void doCollapse()
    {
		int cntrC, nNumFalling = 0;

		bBlocksFalling = false;
		nFrameCount = nBlockFrame = 0;
		for (cntrC = 0; cntrC < PLAYFIELDHEIGHT; ++cntrC) {
			nColumnTops[cntrC] = clpsGrid.getTopBlock(cntrC);
			nColumnGaps[cntrC] = clpsGrid.collapseColumn(cntrC);
			nNumFalling += nColumnGaps[cntrC];
		}
		if (nNumFalling > 0)
			bBlocksFalling = true;
//		repaint();
	}
	//---------------------------------------------------------------------------
	void updateCollapse(Graphics g)
	{
		int cntrC, nSX, nSY, nSY2, nGap;

		if (nFrameCount > BLOCKFULLSIZE)
			nFrameCount = BLOCKFULLSIZE;
		nGap = nFrameCount - nBlockFrame;
		for (cntrC = 0; cntrC < PLAYFIELDHEIGHT; ++cntrC) {
			if (nColumnGaps[cntrC] > 0) {
				nSX = cntrC * BLOCKFULLSIZE + PLAYFIELDX;
				nSY = (Grid.clpsNUMROWS - nColumnTops[cntrC] - 1) * BLOCKFULLSIZE + PLAYFIELDY + nBlockFrame;
				nSY2 =(1+nColumnTops[cntrC]-nColumnGaps[cntrC]) * BLOCKFULLSIZE;
//				nSY2 =(nColumnTops[cntrC]-nColumnGaps[cntrC]) * BLOCKFULLSIZE;
				g.copyArea( nSX, nSY, BLOCKFULLSIZE, nSY2, 0, nGap);
//				g.setColor(Color.gray);
//				g.fillRect( nSX, nSY, BLOCKFULLSIZE, nSY2);
				g.setColor(Color.black);
				g.fillRect(nSX,nSY,BLOCKFULLSIZE, nGap);
			}
		}
		nBlockFrame = nFrameCount;
		if (nFrameCount == BLOCKFULLSIZE)
			doCollapse();
	}
}


