/*
 * Color Collapse
 * Copyright (c) 1998, 2002, 2004-2006 Blazing Games Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package com.blazinggames.cc;

import java.awt.*;

/**
 * Draws the image used in the title
 * 
 * @author Billy D. Spelchan
 * @version 1.0 OSR
 */
public class ImageLabel
extends Canvas
{
// *********************
// ***** VARIABLES *****
// *********************
	private static final long serialVersionUID = 6767070100L;
	
    private Image _image;
    private boolean _stretch;


// ************************
// ***** CONSTRUCTORs *****
// ************************

    public ImageLabel(Image i, boolean stretch)
    {
        super();
        _image = i;
        _stretch = stretch;
        setBackground(Color.black);
    }


// *********************************
// ***** METHODS - From Canvas *****
// *********************************

    public void paint(Graphics g)
    {
        if (_image == null)
            return;
        Dimension d = getSize();
        int iw = _image.getWidth(this);
        int ih = _image.getHeight(this);
        if (_stretch)
        {
            g.drawImage(_image, 0,0,d.width,d.height, 0,0,iw,ih, this);
        }
        else
        {
            int ix = (d.width - iw) / 2;
            int iy = (d.height - iw) / 2;
            g.drawImage(_image, ix, iy, this);
        }
    }
}
