/*
 * Color Collapse
 * Copyright (c) 1998, 2002, 2004-2006 Blazing Games Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package com.blazinggames.cc;

import java.awt.*;

/**
 * The starting menu that the player uses to select their puzzle set
 * 
 * @author Billy D. Spelchan
 * @version 1.0 OSR
 */
public class Menu
extends Panel
{
// *********************
// ***** CONSTANTS *****
// *********************
	private static final long serialVersionUID = 6767080100L;
	
    private static final String TITLE = "TITLE";
/*    
	static final int IMAGEWIDTH = 340;
	static final int IMAGEHEIGHT = 120;
	static final String sPasswords[] = {
		"easy", "pizza", "lore", "hero",
		"normal", "future", "destiny", "guardian",
		"hard", "pepperoni", "chocolate", "computer" };
*/
	// *** VARIABLES ***

    // Title Image
	Image iTitle;

    // Buttons
    Button btnEasy, btnNormal, btnHard, btnPassword;
    // Text Fields used
    TextField tfPassword;

    // Labels
    Label lblPassword;

    Canvas cImage;
    Panel pLevels;
    Panel pPassword;

// ***********************
// ***** CONSTRUCTOR *****
// ***********************
    
    Menu(Collapse al)
    {
        String s = (String) al._config.get(TITLE);
        if (s != null)
            iTitle = al.getImage(al.getDocumentBase(), s);
        else
            iTitle = null;

		// Initiate the Button components
		btnEasy = new Button("Easy");
		btnEasy.addActionListener(al);
		btnNormal = new Button("Normal");
		btnNormal.addActionListener(al);
		btnHard = new Button("Hard");
		btnHard.addActionListener(al);
		btnPassword = new Button("Use Password");
		btnPassword.addActionListener(al);
		// Initiate the TextField components
		tfPassword = new TextField();
		// Initiate the Label components
		lblPassword = new Label("Password");

        cImage = new ImageLabel(iTitle, true);

        // set up the layout
		setLayout(new GridLayout(3,1, 10,10));

    	pLevels = new Panel(new GridLayout(3,1, 10, 10));
        pLevels.add("Easy", btnEasy);
        pLevels.add("Normal", btnNormal);
        pLevels.add("Hard", btnHard);
        
    	pPassword = new Panel(new GridLayout(3,1, 10,10));
        pPassword.add("PassText", lblPassword);
        pPassword.add("PassTF", tfPassword);
        pPassword.add("PassBtn", btnPassword);
        
        add("title", cImage);
		add("levels", pLevels);
		add("password", pPassword);

	}

    public String getPWText()
    {
        return tfPassword.getText();
    }
}
