/*
 * Color Collapse
 * Copyright (c) 1998, 2002, 2004-2006 Blazing Games Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package com.blazinggames.cc;

import java.awt.*;

/**
 * The between level message used to give players passwords
 * 
 * @author Billy D. Spelchan
 * @version 1.0 OSR
 */
public class Message
extends Panel
{
// *** CONSTANTS ***
	private static final long serialVersionUID = 6767020100L;
	
    static final String WIN = "WIN";
	static final int WINIMAGEX = 180;
	static final int WINIMAGEY = 100;
	static final int PASSWORDY1 = 275;
	static final int PASSWORDY2 = 350;

	// *** VARIABLES ***
	Image iWin;
			// Level Won image
	String sPassword;
			// Password for next level
	boolean bSectionComplete;
			// set to true when all levels in section complete
	static Font fontMessage = new Font("TimesRoman", Font.PLAIN, 32);

	// *** CONSTRUCTOR ***
	Message(Collapse al)
    {
        String s = (String) al._config.get(WIN);
        if (s != null)
            iWin = al.getImage(al.getDocumentBase(), s);
        else
            iWin = null;

		this.setBackground(Color.black);
	}

// *** Parameter setting functions ***
	// Set the password for the next level
	public void setPassword(String sP)
    {
		sPassword = sP;
	}

	// Sets the section complete state
	public void setComplete(boolean bC)
    {
		bSectionComplete = bC;
	}

// *** PAINTING functions ***
	public void paint(Graphics g) {
        if (iWin != null)
            g.drawImage(iWin,WINIMAGEX,WINIMAGEY,this);
		g.setFont(fontMessage);
		if (bSectionComplete) {
			g.setColor(Color.blue);
			g.drawString("SECTION COMPLETE!", 100, PASSWORDY1);
		}
		else {
			g.setColor(Color.red);
			g.drawString("Password:", 100, PASSWORDY1);
			g.setColor(Color.orange);
			g.drawString(sPassword, 150, PASSWORDY2);
		}
	}

}