﻿/*
Dozen Days of Dice 
Copyright (c) 2007-2008 Blazing Games Inc.

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

* REVISION HISTORY
* August 3, 2007 First version of this interface
*/
package com.blazinggames.dozendays.dice
{
	/**
	 * a standard interface for die classes so that rolling can be done in a 
	 * uniform manner. If an animated roll is desired, you simply start the roll
	 * using the startRolling function and at the end of the desired animation
	 * cycle, you end the animation with the stopRolling function. If you just
	 * need a random number from the die and don't need rolling animation, the
	 * quickRoll function can be used. You can also force the value of a roll
	 * by calling the setValue function.
	 *
	 * @author Billy D. Spelchan
	 * @version 1.0
	 * Copyright (c) 2007 Blazing Games Inc. All Rights Reserved.
	*/
	public interface IRoll
	{
		/**
		 * Starts the rolling animation.
		*/
		function startRolling():void;
		
		/**
		 * Immediately stops the rolling animation and returns the number that the
		 * die stopped on.
		 *
		 * @return value of the die once the animation has stopped.
		*/
		function stopRolling():uint;
				
		/**
		 * The equivalent of starting the die roll then stopping it. In other words,
		 * this rolls the die without any animation.
		 *
		 * @return the new value of the die
		*/
		function quickRoll():uint;
		
		/**
		 * If the die is rolling, this will return a value of 0, otherwise it 
		 * returns the current value the die is showing.
		 *
		 * @return value of the die
		*/
		function getValue():uint;
		
		/**
		 * Sets the value of the die. If the value specified is invalid, the last
		 * value of the die will be retained.
		*/
		function setValue(n:uint):void;
	} // end interface
} // end package