﻿/*
Dozen Days of Dice 
Copyright (c) 2007-2008 Blazing Games Inc.

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

* REVISION HISTORY
* August 3, 2007 First version of this class
*/
package com.blazinggames.dozendays.dice
{
	import flash.display.MovieClip;
	import flash.events.Event;
	/**
	 * Your basic six sided die.
	 *
	 * @author Billy D. Spelchan
	 * @version 1.0
	 * Copyright (c) 2007 Blazing Games Inc. All Rights Reserved.
	*/
	public class SixSidedDie
	extends MovieClip
	implements IRoll
	{
// *********************
// ***** VARIABLES *****
// *********************

		protected var mValue:uint;
		protected var mIsRolling:Boolean;

		public function SixSidedDie()
		{
			mValue = 1;
			mIsRolling = false;
			addEventListener(Event.ENTER_FRAME, handleRolling);
			gotoAndStop(1);
		}
		
// **************************************
// ***** Functions - Event handlers *****
// **************************************

		public function handleRolling(evt:Event):void
		{
			if (mIsRolling) {
				quickRoll();
			}
		}
	
// **********************************
// ***** Functions - From IRoll *****
// **********************************

		/**
		 * Starts the rolling animation.
		*/
		public function startRolling():void
		{
			mIsRolling = true;
		}
		
		/**
		 * Immediately stops the rolling animation and returns the number that the
		 * die stopped on.
		 *
		 * @return value of the die once the animation has stopped.
		*/
		public function stopRolling():uint
		{
			mIsRolling = false;
			return quickRoll();
		}
				
		/**
		 * The equivalent of starting the die roll then stopping it. In other words,
		 * this rolls the die without any animation.
		 *
		 * @return the new value of the die
		*/
		public function quickRoll():uint
		{
			mValue = uint(Math.floor(Math.random() * 6) + 1);
			gotoAndStop(mValue);
			return mValue;
		}
		
		/**
		 * If the die is rolling, this will return a value of 0, otherwise it 
		 * returns the current value the die is showing.
		 *
		 * @return value of the die
		*/
		public function getValue():uint
		{
			if (mIsRolling)
				return 0;
			else
				return mValue;
		}
		
		/**
		 * Sets the value of the die. If the value specified is invalid, the last
		 * value of the die will be retained.
		*/
		public function setValue(n:uint):void
		{
			mValue = n;
			gotoAndStop(mValue);
		}
		
	} // end interface
} // end package
