/*
Dozen Days of Dice episode 6: Drop Dead
Copyright (c) 2008 Blazing Games Inc.

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation; either version 2 of the License, or (at your option) any later 
version.

This program is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more 
details.

You should have received a copy of the GNU General Public License along with 
this program; if not, write to the Free Software Foundation, Inc., 
59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
package com.blazinggames.dozendays.dice.dropdead
{
	// Adobe Imports
	import flash.display.SimpleButton;
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.media.SoundMixer;
	import flash.media.SoundTransform;
	import flash.text.TextField;
	
	// Blazing Game imports
	import com.blazinggames.dozendays.dice.*;
	
	/**
	 * The Drop Dead game manager. It handles the game and the players.
	 *
	 * @author Billy D. Spelchan
	 * @version 1.0
	 * Copyright (c) 2008 Blazing Games Inc. All Rights Reserved.
	*/
	public class DropDead
	extends MovieClip
	{
// *********************
// ***** CONSTANTS *****
// *********************

		public const NUM_PLAYERS = 6;
		public const STATE_INITIALIZING:int = 0;
		public const STATE_STARTING:int = 1;
		public const STATE_PLAYING:int = 2;
		public const STATE_FINISHING:int = 3;

		public const PLAYER_NAMES:Array = new Array(
				"Red player", "Yellow player", "Green player",
				"Cyan player", "Blue player", "Purple player",
				"End of Round");

// *********************
// ***** VARIABLES *****
// *********************

		protected var _playerArray:Array;
		protected var _orderArray:Array;
		protected var _gameState:int;
//		protected var _currentOrder:int;
		protected var _currentPlayer:int;
		protected var _currentRound:int = 0;
		protected var _soundFlag:Boolean;
		protected var _soundTransformOn:SoundTransform;
		protected var _soundTransformOff:SoundTransform;


		// note that all _*_movie, _*_btn and _*_txt variables are in movie

// ***********************
// ***** CONSTRUCTOR *****
// ***********************

		public function DropDead()
		{
			_game_movie.setManager(this);
			_playerArray = new Array(
				_redPlayer_movie, _yellowPlayer_movie, _greenPlayer_movie,
				_cyanPlayer_movie, _bluePlayer_movie, _purplePlayer_movie
			);
			_orderArray = new Array(NUM_PLAYERS);
			for (var cntr:int = 0; cntr < NUM_PLAYERS; ++cntr)
				_orderArray[cntr] = cntr;
			_gameState = STATE_INITIALIZING;
			_newRound_btn.addEventListener(
						flash.events.MouseEvent.MOUSE_UP, handleNewRound);
			_title_btn.addEventListener(
						flash.events.MouseEvent.MOUSE_UP, handleQuit);
			startRound();
			_soundFlag = false;
			_soundTransformOn = new SoundTransform(1, 0);
			_soundTransformOff = new SoundTransform(0, 0);
			SoundMixer.soundTransform = _soundTransformOff;
			_soundon_btn.visible = false;
			_soundoff_btn.visible = true;
			_soundon_btn.addEventListener(
					flash.events.MouseEvent.MOUSE_UP, handleSoundToggle);
			_soundoff_btn.addEventListener(
					flash.events.MouseEvent.MOUSE_UP, handleSoundToggle);
			stop();
		}
		
// **************************************
// ***** Functions - Event handlers *****
// **************************************

		public function handleNewRound(evt:MouseEvent)
		{
			startRound();
		}
		
		public function handleQuit(evt:MouseEvent)
		{
			var evnt:Event = new Event("RETURNTOTITLE");
			this.dispatchEvent(evnt);
		}

		public function handleSoundToggle(evt:Event)
		{
			if (_soundFlag) {
				SoundMixer.soundTransform = _soundTransformOff;
			} else {
				SoundMixer.soundTransform = _soundTransformOn;
			}
			_soundFlag = !_soundFlag;
			_soundon_btn.visible = _soundFlag;
			_soundoff_btn.visible = !_soundFlag;
		}

// ***************************************
// ***** Functions - General control *****
// ***************************************

		public function getGame():DropDeadGame
		{
			return _game_movie;
		}

		public function startRound()
		{
			var cntr:int;

			for (cntr = 0; cntr < NUM_PLAYERS; ++cntr) {
				_playerArray[cntr].startingRound();
			}
			_currentPlayer = -1;
			_newRound_btn.visible = false;
			_title_btn.visible = false;
			_game_movie.visible = true;
			++_currentRound;
			_round_txt.text = "Round " + _currentRound;
			startNextPlayer();
		}

		public function setMessage(s:String)
		{
			_round_txt.text = s;
		}

		public function startNextPlayer()
		{
			var cntr:int;
			
			++_currentPlayer;
			setMessage(PLAYER_NAMES[_currentPlayer]);
			if (_currentPlayer >= NUM_PLAYERS) {
				// HANDLE WIN DETERMINATION
				var temp:int;
				var highestScore:int = _playerArray[cntr].getScore();
				var isATie:Boolean = false;
				var winType:int = 2;
				for (cntr = 1; cntr < NUM_PLAYERS; ++cntr) {
					temp = _playerArray[cntr].getScore();
					if (temp > highestScore) {
						isATie = false;
						highestScore = temp;
					} else if (temp == highestScore)
						isATie = true;
				}
				if (isATie)
					winType = 1;
				for (cntr = 0; cntr < NUM_PLAYERS; ++cntr) 
					if (_playerArray[cntr].getScore() == highestScore)
						_playerArray[cntr].setResults(winType);
					else
						_playerArray[cntr].setResults(0);
				_newRound_btn.visible = true;
				_title_btn.visible = true;
				_game_movie.changeState(DropDeadGame.STATE_DONE);
			}
			else {
				_playerArray[_currentPlayer].startPlay(this);
			}
		}

	} // end class
} // end package

