﻿/*
Dozen Days of Dice episode 6: Drop Dead
Copyright (c) 2008 Blazing Games Inc.

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation; either version 2 of the License, or (at your option) any later 
version.

This program is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more 
details.

You should have received a copy of the GNU General Public License along with 
this program; if not, write to the Free Software Foundation, Inc., 
59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
package com.blazinggames.dozendays.dice.dropdead
{
	// Adobe Imports
	import flash.display.SimpleButton;
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	
	// Blazing Game imports
	import com.blazinggames.dozendays.dice.*;
	
	/**
	 * The Drop Dead game. All players share a single instance of this game, but
	 * track their own scoring separately.
	 *
	 * @author Billy D. Spelchan
	 * @version 1.0
	 * Copyright (c) 2008 Blazing Games Inc. All Rights Reserved.
	*/
	public class DropDeadGame
	extends MovieClip
	{
// *********************
// ***** CONSTANTS *****
// *********************

		// layout constants
		protected const DIE_SIZE:int = 128;
		protected const NORMAL_Y:int = 0;
		protected const SELECTED_Y:int = 32;

		// player state constants
		public static const STATE_STARTING:int = 0;
		public static const STATE_WAITING:int = 1;
		public static const STATE_KEEPING:int = 2;
		public static const STATE_DONE:int = 3;

// *********************
// ***** VARIABLES *****
// *********************

		protected var _manager:DropDead;

		protected var _dice:Array;
		protected var _dead:Array;
		protected var _playerState:int;
		protected var _dropDeadPlayer:DropDeadPlayer;
		protected var _currentScore;

		protected var _sounds:Array;
		// note that all _*_movie, _*_btn and _*_txt variables are in movie

// ***********************
// ***** CONSTRUCTOR *****
// ***********************

		public function DropDeadGame()
		{
			_dice = new Array(_die1_movie, _die2_movie, _die3_movie, 
					_die4_movie, _die5_movie);
			_dead = new Array();
			_sounds = new Array(
				new die_wav(), new dice2_wav(), new dice3_wav(), 
				new dice4_wav(), new dice5_wav());
			_roll_btn.addEventListener(
					flash.events.MouseEvent.MOUSE_UP, handleRoll);
			_done_btn.addEventListener(
					flash.events.MouseEvent.MOUSE_UP, handleDone);
			changeState(STATE_STARTING);
			stop();
		}
		
// **************************************
// ***** Functions - Event handlers *****
// **************************************

		public function handleRoll(evt:MouseEvent)
		{
			rollTheDice();
		}

		public function handleDone(evt:MouseEvent)
		{
			_dropDeadPlayer.setScore(_currentScore, true);
			for (var cntr:int = 0; cntr < 5; ++cntr)
				_dice[cntr].y = NORMAL_Y;
		}

		private function rollTheDice()
		{
			var diceRolled:int = 0;
			var dieValue:int, cntr:int;

			if (_playerState == STATE_STARTING) {
				for (cntr = 0; cntr < 5; ++cntr) {
					_dice[cntr].y = NORMAL_Y;
					_dice[cntr].quickRoll();
					_dead[cntr] = false;
					++diceRolled;
				}
			} else {
				for (cntr = 0; cntr < 5; ++cntr) {
					dieValue = _dice[cntr].getValue(); 
					if ( (dieValue == 2) || (dieValue == 5) ) {
						_dice[cntr].y = SELECTED_Y;
						_dead[cntr] = true;
					} else {
						_dice[cntr].y = NORMAL_Y;
						_dice[cntr].quickRoll();
						++diceRolled;
					}
				}
			}
			if (diceRolled > 0)
				_sounds[diceRolled-1].play();
/*				
			if (((diceRolled == 0) || (_playerState != STATE_STARTING)) && 
					(_dropDeadPlayer != null))
				_dropDeadPlayer.setScore(_dice[0].getValue(),_dice[1].getValue(),
						_dice[2].getValue(),_dice[3].getValue(),
						_dice[4].getValue());
			else
*/
			changeState(STATE_KEEPING);
		}

// ***************************************
// ***** Functions - General control *****
// ***************************************

		public function setManager(man:DropDead)
		{
			_manager = man;
		}

		public function startGame(player:DropDeadPlayer)
		{
			_dropDeadPlayer = player;
			
			changeState(STATE_STARTING);
		}

		public function playAI(player:DropDeadPlayer)
		{
			trace ("AI not implemented");
		}

		public function changeState(newState:int):void
		{
			var cntr:int;

			_playerState = newState;
			trace ("Changing state to " + newState);
			switch (newState) {
			case STATE_STARTING:
				_done_btn.visible = true;
				_roll_btn.visible = true;
				_currentScore = 0;
				break;
			case STATE_WAITING:
			case STATE_KEEPING:
				var isDead:Boolean = false;
				var roundScore:int = 0;
				var deadCount:int = 0;
				var dieValue:int;
				for (cntr = 0; cntr < 5; ++cntr) {
					dieValue = _dice[cntr].getValue();
					if (_dead[cntr] == false)
						if ((dieValue == 2) || (dieValue == 5)) {
							isDead = true;
							++deadCount;
						} else
							roundScore += dieValue;
					else
						++deadCount;
				}
				
				if (isDead)
					_manager.setMessage("No points scored");
				else {
					_currentScore += roundScore;
					_manager.setMessage("roll earned " + roundScore);
					_dropDeadPlayer.setScore(_currentScore, false);
				}
				_done_btn.visible = true;
				_roll_btn.visible = (deadCount < 5);
				break;			
			case STATE_DONE:
				_done_btn.visible = false;
				_roll_btn.visible = false;
				break;
			default:
				trace("Unknown State encountered: " + newState);
			}
		}
		
		public function getPlayerState():int
		{
			return _playerState;
		}

	} // end class
} // end package

