/*
Dozen Days of Dice episode 6: Drop Dead
Copyright (c) 2008 Blazing Games Inc.

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation; either version 2 of the License, or (at your option) any later 
version.

This program is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more 
details.

You should have received a copy of the GNU General Public License along with 
this program; if not, write to the Free Software Foundation, Inc., 
59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
package com.blazinggames.dozendays.dice.dropdead
{
	// Adobe Imports
	import flash.display.SimpleButton;
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	
	// Blazing Game imports
	import com.blazinggames.dozendays.dice.*;
	
	/**
	 * The Drop Dead player. It handles the game and the players.
	 *
	 * @author Billy D. Spelchan
	 * @version 1.0
	 * Copyright (c) 2008 Blazing Games Inc. All Rights Reserved.
	*/
	public class DropDeadPlayer
	extends MovieClip
	{
// *********************
// ***** CONSTANTS *****
// *********************

		public static const RESULTS_NONE:int = 0;
		public static const RESULTS_LOSE:int = 0;
		public static const RESULT_TIE:int = 1;
		public static const RESULT_WIN:int = 2;

// *********************
// ***** VARIABLES *****
// *********************

		protected var _gameScore:int;
		protected var _points:int;
		protected var _playingGame:Boolean;
		protected var _manager:DropDead;

		// note that all _*_movie, _*_btn and _*_txt variables are in movie

// ***********************
// ***** CONSTRUCTOR *****
// ***********************

		public function DropDeadPlayer()
		{
			_playingGame = false;
			_gameScore = 0;
			_points = 0;
			stop();
		}

// **************************************
// ***** Functions - Event handlers *****
// **************************************


// ***************************************
// ***** Functions - General control *****
// ***************************************

		public function startingRound()
		{
			_gameScore = 0;
			_score_txt.text = "Not played yet!";
			_flash_movie.visible = false;
			setResults(RESULTS_NONE);
		}

		public function startPlay(manager:DropDead)
		{
			var game:DropDeadGame = manager.getGame();
			_manager = manager;
			_flash_movie.visible = true;
			game.startGame(this);
			_playingGame = true;
			_score_txt.text = "Score = 0";
		}

		public function setScore(score:int, done:Boolean)
		{
			_gameScore = score;
			trace ("score code was: " + _gameScore);
			_score_txt.text = "Score = " + _gameScore;
			if (done) {
				_flash_movie.visible = false;
				_playingGame = false;
				_manager.startNextPlayer();
			}
		}
		
		public function getScore():int
		{
			return _gameScore;
		}
		
		public function setResults(n:int)
		{
			switch (n)
			{
			case RESULTS_LOSE:
				_results_txt.text = " ";
				break;
			case RESULT_TIE:
				_results_txt.text = "TIE";
				break;
			case RESULT_WIN:
				_results_txt.text = "WIN";
				break;
			}
			
			_points += n;
			_points_txt.text = "Points " + _points;
		}
	} // end class
} // end package

