/*
Dozen Days of Dice episode 4: Poker Dice 
Copyright (c) 2007-2008 Blazing Games Inc.

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation; either version 2 of the License, or (at your option) any later 
version.

This program is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more 
details.

You should have received a copy of the GNU General Public License along with 
this program; if not, write to the Free Software Foundation, Inc., 
59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
package com.blazinggames.dozendays.dice.pokerdice
{
	// Adobe Imports
	import flash.display.SimpleButton;
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	
	// Blazing Game imports
	import com.blazinggames.dozendays.dice.*;
	
	/**
	 * The Threes game. All players share a single instance of this game, but
	 * track their own scoring separately.
	 *
	 * @author Billy D. Spelchan
	 * @version 1.0
	 * Copyright (c) 2007-2008 Blazing Games Inc. All Rights Reserved.
	*/
	public class PokerGame
	extends MovieClip
	{
// *********************
// ***** CONSTANTS *****
// *********************

		// layout constants
		protected const DIE_SIZE:int = 128;
		protected const NORMAL_Y:int = 0;
		protected const SELECTED_Y:int = 32;

		// player state constants
		public static const STATE_STARTING:int = 0;
		public static const STATE_WAITING:int = 1;
		public static const STATE_KEEPING:int = 2;
		public static const STATE_DONE:int = 3;

		// keep state constants
		protected const KEEP_NO:int = 0;
		protected const KEEP_YES:int = 1;
		protected const KEEP_LOCKED:int = 2;

// *********************
// ***** VARIABLES *****
// *********************

		protected var _dice:Array;
		protected var _diceButtons:Array;
		protected var _diceHolding:Array;
		protected var _playerState:int;
		protected var _pokerPlayer:PokerPlayer;
		
		protected var _sounds:Array;
		// note that all _*_movie, _*_btn and _*_txt variables are in movie

// ***********************
// ***** CONSTRUCTOR *****
// ***********************

		public function PokerGame()
		{
			_dice = new Array(_die1_movie, _die2_movie, _die3_movie, 
					_die4_movie, _die5_movie);
			_diceButtons = new Array(_hold1_btn, _hold2_btn, _hold3_btn,
					_hold4_btn, _hold5_btn);
			_diceHolding = new Array(5);
			for (var cntr:int = 0; cntr < 5; ++cntr) {
				_diceButtons[cntr].addEventListener(
						flash.events.MouseEvent.MOUSE_UP, handleHold);
			}
			_sounds = new Array(
				new die_wav(), new dice2_wav(), new dice3_wav(), 
				new dice4_wav(), new dice5_wav());
			_roll_btn.addEventListener(
					flash.events.MouseEvent.MOUSE_UP, handleRoll);
			_finish_btn.addEventListener(
					flash.events.MouseEvent.MOUSE_UP, handleRoll);
			changeState(STATE_STARTING);
			stop();
		}
		
// **************************************
// ***** Functions - Event handlers *****
// **************************************

		public function handleRoll(evt:MouseEvent)
		{
			rollTheDice();
		}

		private function rollTheDice()
		{
			var diceRolled:int = 0;
			for (var cntr:int = 0; cntr < 5; ++cntr)
			if (_diceHolding[cntr] != KEEP_NO) 
				_diceHolding[cntr] = KEEP_LOCKED;
			else {
				_dice[cntr].quickRoll();
				++diceRolled;
			}
			if (diceRolled > 0)
				_sounds[diceRolled-1].play();
			if (((diceRolled == 0) || (_playerState != STATE_STARTING)) && 
					(_pokerPlayer != null))
				_pokerPlayer.setScore(_dice[0].getValue(),_dice[1].getValue(),
						_dice[2].getValue(),_dice[3].getValue(),
						_dice[4].getValue());
			else
				changeState(STATE_KEEPING);
		}

		public function handleHold(evt:MouseEvent)
		{
			var die:int = (evt.stageX - x)/ DIE_SIZE;
			trace ("Toggling hold for die " + die);
			if (_diceHolding[die] == KEEP_NO) {
				_dice[die].y = SELECTED_Y;
				_diceHolding[die] = KEEP_YES;
			} else if (_diceHolding[die] == KEEP_YES) {
				_dice[die].y = NORMAL_Y;
				_diceHolding[die] = KEEP_NO;
			} else
				trace("error - invalid click. ignored!");			
		}

// ***************************************
// ***** Functions - General control *****
// ***************************************

		public function startGame(player:PokerPlayer)
		{
			_pokerPlayer = player;
			changeState(STATE_STARTING);
		}

		public function playAI(player:PokerPlayer)
		{
			_pokerPlayer = player;
			
			if (_playerState != STATE_KEEPING)
				rollTheDice();

			var temp:int = player.calculateScore(_dice[0].getValue(),
					_dice[1].getValue(), _dice[2].getValue(),
					_dice[3].getValue(), _dice[4].getValue());
			var scoreArray:Array = new Array(5);
			var cntr:int;
			for (cntr = 0; cntr < 5; ++cntr) {
				scoreArray[cntr] = temp & 7;
				temp >>= 3;
			}
			// temp now holds the score mode
			trace ("AI has rolled reslut type " + temp);
			switch (temp) {
				case PokerPlayer.HAND_FIVEOFAKIND:
				case PokerPlayer.HAND_FOUROFAKIND:
				case PokerPlayer.HAND_THREEOFAKIND:
				case PokerPlayer.HAND_PAIR:
					// keep all matching die
					for (cntr = 0; cntr < 5; ++cntr) {
						if (_dice[cntr].getValue() == scoreArray[4])
							_diceHolding[cntr] = KEEP_YES;
					}						
					break;
					
				case PokerPlayer.HAND_STRAIGHT:
				case PokerPlayer.HAND_FULLHOUSE:
					// keep entire hand!
					for (cntr = 0; cntr < 5; ++cntr) {
						_diceHolding[cntr] = KEEP_YES;
					}						
					break;

				case PokerPlayer.HAND_TWOPAIRS:
					for (cntr = 0; cntr < 5; ++cntr) {
						if ((_dice[cntr].getValue() == scoreArray[4]) ||
								(_dice[cntr].getValue() == scoreArray[3]))
							_diceHolding[cntr] = KEEP_YES;
					}						
					break;

				case PokerPlayer.HAND_HIGH:
					break;
			}
			
			var AI_Debug:String = "AI -> "
			for (cntr = 0; cntr < 5; ++cntr) {
				AI_Debug += ( _dice[cntr].getValue() + "-")
				if (_diceHolding[cntr] == KEEP_YES)
					AI_Debug += "keep ";
				else
					AI_Debug += "roll ";
			}						
			trace(AI_Debug);
			rollTheDice();
		}

		public function changeState(newState:int):void
		{
			var cntr:int;

			_playerState = newState;
			trace ("Changing state to " + newState);
			switch (newState) {
			case STATE_STARTING:
				for (cntr = 0; cntr < 5; ++cntr) {
					_dice[cntr].y = NORMAL_Y;
					_diceHolding[cntr] = KEEP_NO;
					_diceButtons[cntr].visible = false;
				}
				_finish_btn.visible = false;
				_roll_btn.visible = true;
				break;
			case STATE_WAITING:
			case STATE_KEEPING:
				for (cntr = 0; cntr < 5; ++cntr) {
					_diceButtons[cntr].visible = 
							_diceHolding[cntr] != KEEP_LOCKED;
				}
				_finish_btn.visible = true;
				_roll_btn.visible = false;
				break;			
			case STATE_DONE:
				for (cntr = 0; cntr < 5; ++cntr) {
					_dice[cntr].y = NORMAL_Y;
					_diceHolding[cntr] = KEEP_NO;
					_diceButtons[cntr].visible = false;
				}
				_finish_btn.visible = false;
				_roll_btn.visible = false;
				break;
			default:
				trace("Unknown State encountered: " + newState);
			}
		}
		
		public function getPlayerState():int
		{
			return _playerState;
		}

	} // end class
} // end package

