/*
Dozen Days of Dice episode 4: Poker Dice 
Copyright (c) 2007-2008 Blazing Games Inc.

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation; either version 2 of the License, or (at your option) any later 
version.

This program is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more 
details.

You should have received a copy of the GNU General Public License along with 
this program; if not, write to the Free Software Foundation, Inc., 
59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
package com.blazinggames.dozendays.dice.pokerdice
{
	// Adobe Imports
	import flash.display.SimpleButton;
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	
	// Blazing Game imports
	import com.blazinggames.dozendays.dice.*;
	
	/**
	 * The Threes game manager. It handles the game and the players.
	 *
	 * @author Billy D. Spelchan
	 * @version 1.0
	 * Copyright (c) 2007-2008 Blazing Games Inc. All Rights Reserved.
	*/
	public class PokerPlayer
	extends MovieClip
	{
// *********************
// ***** CONSTANTS *****
// *********************

		public static const HAND_FIVEOFAKIND:int = 7;
		public static const HAND_FOUROFAKIND:int = 6;
		public static const HAND_STRAIGHT:int = 5;
		public static const HAND_FULLHOUSE:int = 4;
		public static const HAND_THREEOFAKIND:int = 3
		public static const HAND_TWOPAIRS:int = 2;
		public static const HAND_PAIR:int = 1;
		public static const HAND_HIGH:int = 0;

		public static const HAND_LABELS:Array = new Array(
			"High number", "Pair", "Two pairs", "Three of a kind",
			"Full House", "Straight", "Four of a Kind", "Five of a Kind"
		);
		public static const RESULTS_NONE:int = 0;
		public static const RESULTS_LOSE:int = 0;
		public static const RESULT_TIE:int = 1;
		public static const RESULT_WIN:int = 2;

// *********************
// ***** VARIABLES *****
// *********************

		protected var _hand:Array;
		protected var _gameScore:int;
		protected var _points:int;
		protected var _isHuman:Boolean;
		protected var _playingGame:Boolean;
		protected var _manager:PokerDice;

		// note that all _*_movie, _*_btn and _*_txt variables are in movie

// ***********************
// ***** CONSTRUCTOR *****
// ***********************

		public function PokerPlayer()
		{
			_isHuman = true;
			_playingGame = false;
			_human_btn.addEventListener(flash.events.MouseEvent.MOUSE_UP, 
					handleComputerHumanToggle);
			_computer_btn.addEventListener(flash.events.MouseEvent.MOUSE_UP, 
					handleComputerHumanToggle);
			_human_btn.visible = true;
			_computer_btn.visible = false;
			_gameScore = 0;
			_points = 0;
			_hand = new Array(_die1_movie,_die2_movie,_die3_movie,
					_die4_movie,_die5_movie);
			stop();
		}

// **************************************
// ***** Functions - Event handlers *****
// **************************************

		public function handleComputerHumanToggle(evt:Event)
		{
			if (_isHuman == true) {
				_isHuman = false;
				_human_btn.visible = false;
				_human_btn.removeEventListener(flash.events.MouseEvent.MOUSE_UP, 
						handleComputerHumanToggle);
				_computer_btn.visible = true;
				_computer_btn.addEventListener(flash.events.MouseEvent.MOUSE_UP, 
						handleComputerHumanToggle);
				if (_playingGame == true)
					_manager.getGame().playAI(this);
			} else {
				_isHuman = true;
				_human_btn.visible = true;
				_human_btn.addEventListener(flash.events.MouseEvent.MOUSE_UP, 
						handleComputerHumanToggle);
				_computer_btn.removeEventListener(flash.events.MouseEvent.MOUSE_UP, 
						handleComputerHumanToggle);
				_computer_btn.visible = false;
			}
		}

// ***************************************
// ***** Functions - General control *****
// ***************************************

		public function setPlayOrder(n:int)
		{
			_orderDie_movie.setValue(n);
			_gameScore = 29;
			_score_txt.text = " ";
			_flash_movie.visible = false;
			for (var cntr:int = 0; cntr < 5; ++cntr)
				_hand[cntr].visible = false;
			setResults(0);
		}

		public function startPlay(manager:PokerDice)
		{
			var game:PokerGame = manager.getGame();
			_manager = manager;
			_flash_movie.visible = true;
			game.startGame(this);
			_playingGame = true;
			if (_isHuman == false) // no ai yet
//				_manager.startNextPlayer();
				game.playAI(this);
		}
		
		public function calculateScore(d1:int,d2:int,d3:int,d4:int,d5:int):int
		{
			var dice:Array = new Array(d1,d2,d3,d4,d5);
			var matching:Array = new Array(1,1,0);
			var matchValues:Array = new Array(0,0,0);
			var numMatches:int = 0;
			var isStraight:Boolean = true;
			var cntr:int, temp:int;
			var gameScore = 0;

			dice.sort();
			for (cntr = 1; cntr < 5; ++cntr) {
				if (isStraight) 
					isStraight = dice[cntr] == (dice[cntr-1]+1);
				if (dice[cntr] == dice[cntr-1])
					++matching[numMatches];
				else if (matching[numMatches] > 1) {
					matchValues[numMatches] = dice[cntr-1];
					++numMatches;
				}
			}
			// remember to end match streak for last die
			if (matching[numMatches] > 1) {
				matchValues[numMatches] = dice[4];
				++numMatches;
			}
			
			// now properly score the hand
			if (isStraight) {
				gameScore = HAND_STRAIGHT;
				for (cntr = 0; cntr < 5; ++cntr) {
					gameScore <<= 3;
					gameScore |= dice[4 - cntr];
				}
			} else if (numMatches > 1) {// 2 pairs or full house
				if (matching[0] == matching[1]) {// both are 2
					gameScore = HAND_TWOPAIRS;
					gameScore <<= 3;
					gameScore |= matchValues[1];
					gameScore <<= 3;
					gameScore |= matchValues[0];
					for (cntr = 0; cntr < 5; ++cntr) {
						if ((dice[cntr] != matchValues[0]) && 
								(dice[cntr] != matchValues[1])) {
							gameScore <<= 3;
							gameScore |= dice[cntr];
						}
					}
					gameScore <<= 6;
				} else { // full house
					gameScore = HAND_FULLHOUSE;
					gameScore <<= 3;
					if (matching[0] == 3) {
						gameScore |= matchValues[0];
						gameScore <<= 3;
						gameScore |= matchValues[1];
					} else {
						gameScore |= matchValues[1];
						gameScore <<= 3;
						gameScore |= matchValues[0];
					}
					gameScore <<= 9;
				}
			} else if (numMatches == 1) { // pair..five of a kind
				if (matching[0] == 2)
					gameScore = HAND_PAIR;
				else if(matching[0] == 3)
					gameScore = HAND_THREEOFAKIND;
				else if(matching[0] == 4)
					gameScore = HAND_FOUROFAKIND;
				else if(matching[0] == 5)
					gameScore = HAND_FIVEOFAKIND;
				gameScore <<= 3;
				gameScore |= matchValues[0];
				for (cntr = 0; cntr < 5; ++cntr) {
					if (dice[cntr] != matchValues[0]) {
						gameScore <<= 3;
						gameScore |= dice[cntr];
					}
				}
				temp = (matching[0] - 1) * 3;
				gameScore <<= temp;
			} else {// high die aka broken straight
				gameScore = HAND_HIGH;
				for (cntr = 0; cntr < 5; ++cntr) {
					gameScore <<= 3;
					gameScore |= dice[4 - cntr];
				}
			}

			return gameScore;
		}
		
		public function setScore(d1:int, d2:int, d3:int, d4:int, d5:int)
		{
			var dice:Array = new Array(d1,d2,d3,d4,d5);

			for (var cntr:int = 0; cntr < 5; ++cntr) {
				_hand[cntr].setValue(dice[cntr]);
				_hand[cntr].visible = true;
			}
			
			_gameScore = calculateScore(d1,d2,d3,d4,d5);
			var handType:int = (_gameScore & 0xf8000) >> 15;
			trace ("score code was: " + _gameScore);
			_score_txt.text = HAND_LABELS[handType];
			_flash_movie.visible = false;
			_playingGame = false;
			_manager.startNextPlayer();
		}
		
		public function getScore():int
		{
			return _gameScore;
		}
		
		public function setResults(n:int)
		{
			switch (n)
			{
			case RESULTS_LOSE:
				_results_txt.text = " ";
				break;
			case RESULT_TIE:
				_results_txt.text = "TIE";
				break;
			case RESULT_WIN:
				_results_txt.text = "WIN";
				break;
			}
			
			_points += n;
			_points_txt.text = "Points " + _points;
		}
	} // end class
} // end package

