/*
Dozen Days of Dice episode 5: Sic Bo
Copyright (c) 2008 Blazing Games Inc.

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation; either version 2 of the License, or (at your option) any later 
version.

This program is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more 
details.

You should have received a copy of the GNU General Public License along with 
this program; if not, write to the Free Software Foundation, Inc., 
59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
package com.blazinggames.dozendays.dice.sicbo
{
	// Adobe Imports
	import flash.display.MovieClip;

	public class BackLight
	extends MovieClip
	{
		// ***** CONSTANTS ***************************************************

		// labels
		public static const LABEL_OFF:String = "Off";
		public static const LABEL_DIM:String = "Dim";
		public static const LABEL_ON:String = "On";

		// states

		public static const STATE_OFF:int = 0;
		public static const STATE_DIM:int = 1;
		public static const STATE_ON:int = 2;

		// ***** VARIABLES ***************************************************
		
		protected var _state:int;
		protected var _id:int;
		
		// ***** CONSTRUCTOR *************************************************

		public function BackLight()
		{
		}
		
		// ***** Functions - State control ***********************************
		
		public function getState():int
		{
			return _state;
		}
		
		public function changeState(newState:int)
		{
			_state = newState;
			switch (_state) {
			case STATE_OFF:
				gotoAndPlay(LABEL_OFF);
				break;
			case STATE_DIM:
				gotoAndPlay(LABEL_DIM);
				break;
			case STATE_ON:
				gotoAndPlay(LABEL_ON);
				break;
			default:
				trace("ERROR - Unknown state encountered!");
			}
		}
		
		public function setID(n:int)
		{
			_id = n;
		}
		
		public function getID():int
		{
			return _id;
		}
	} // end class
} // end package

