/*
Dozen Days of Dice episode 5: Sic Bo
Copyright (c) 2008 Blazing Games Inc.

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation; either version 2 of the License, or (at your option) any later 
version.

This program is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more 
details.

You should have received a copy of the GNU General Public License along with 
this program; if not, write to the Free Software Foundation, Inc., 
59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
package com.blazinggames.dozendays.dice.sicbo
{
	// Adobe Imports
	import flash.display.MovieClip;
	import flash.display.SimpleButton;
	import flash.events.Event;
	import flash.events.EventDispatcher;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	
	public class BetPopup
	extends MovieClip
	{
		// ***** CONSTANTS ***************************************************

		public static const BET_EVENT:String = "BET MADE";
		
		// ***** VARIABLES ***************************************************

		protected var _lastBet:int;

		// ***** CONSTRUCTOR *************************************************

		public function BetPopup()
		{
			_bet_0_btn.addEventListener(MouseEvent.CLICK, bet0);
			_bet_1_btn.addEventListener(MouseEvent.CLICK, bet1);
			_bet_2_btn.addEventListener(MouseEvent.CLICK, bet2);
			_bet_3_btn.addEventListener(MouseEvent.CLICK, bet3);
			_bet_4_btn.addEventListener(MouseEvent.CLICK, bet4);
			_bet_5_btn.addEventListener(MouseEvent.CLICK, bet5);
		}

		protected function broadcastBet()
		{
			var evnt:Event = new Event(BET_EVENT);
			this.dispatchEvent(evnt);
		}

		protected function bet0(evt:Event)
		{
			setBet(0);
			broadcastBet();
		}
		protected function bet1(evt:Event)
		{
			setBet(1);
			broadcastBet();
		}
		protected function bet2(evt:Event)
		{
			setBet(2);
			broadcastBet();
		}
		protected function bet3(evt:Event)
		{
			setBet(3);
			broadcastBet();
		}
		protected function bet4(evt:Event)
		{
			setBet(4);
			broadcastBet();
		}
		protected function bet5(evt:Event)
		{
			setBet(5);
			broadcastBet();
		}
		
		// ***** Functions - State control ***********************************
		
		public function setBet(n:int)
		{
			_lastBet = n;
			_bet_0_movie.visible = (n == 0);
			_bet_1_movie.visible = (n == 1);
			_bet_2_movie.visible = (n == 2);
			_bet_3_movie.visible = (n == 3);
			_bet_4_movie.visible = (n == 4);
			_bet_5_movie.visible = (n == 5);
		}
		
		public function setBetName(s:String)
		{
			_bet_txt.text = s;
		}
		
		public function getLastBet():int
		{
			return _lastBet;
		}
	} // end class
} // end package

