/*
Dozen Days of Dice episode 5: Sic Bo
Copyright (c) 2008 Blazing Games Inc.

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation; either version 2 of the License, or (at your option) any later 
version.

This program is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more 
details.

You should have received a copy of the GNU General Public License along with 
this program; if not, write to the Free Software Foundation, Inc., 
59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
package com.blazinggames.dozendays.dice.sicbo
{
	// Adobe Imports
	import flash.display.SimpleButton;
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.media.SoundMixer;
	import flash.media.SoundTransform;
	import flash.media.Sound;
	import flash.text.TextField;
	
	// Blazing Game imports
	import com.blazinggames.dozendays.dice.*;
	
	/**
	 * The Sic Bo Dice/casino game
	 *
	 * @author Billy D. Spelchan
	 * @version 1.0
	 * Copyright (c) 2008 Blazing Games Inc. All Rights Reserved.
	*/
	public class SicBo
	extends MovieClip
	{
		// ***** CONSTANTS ***************************************************

		// player state constants
		public static const STATE_STARTING:int = 0;
		public static const STATE_WAITING:int = 1;
		public static const STATE_KEEPING:int = 2;
		public static const STATE_DONE:int = 3;

		// single number bets
		public static const BET_1:int = 0;
		public static const BET_2:int = 1;
		public static const BET_3:int = 2;
		public static const BET_4:int = 3;
		public static const BET_5:int = 4;
		public static const BET_6:int = 5;
		// pair combination bets
		public static const BET_COMBO12:int = 6;
		public static const BET_COMBO13:int = 7;
		public static const BET_COMBO14:int = 8;
		public static const BET_COMBO15:int = 9;
		public static const BET_COMBO16:int = 10;
		public static const BET_COMBO23:int = 11;
		public static const BET_COMBO24:int = 12;
		public static const BET_COMBO25:int = 13;
		public static const BET_COMBO26:int = 14;
		public static const BET_COMBO34:int = 15;
		public static const BET_COMBO35:int = 16;
		public static const BET_COMBO36:int = 17;
		public static const BET_COMBO45:int = 18;
		public static const BET_COMBO46:int = 19;
		public static const BET_COMBO56:int = 20;
		// roll Total bets
		public static const BET_TOTAL4:int = 21;
		public static const BET_TOTAL5:int = 22;
		public static const BET_TOTAL6:int = 23;
		public static const BET_TOTAL7:int = 24;
		public static const BET_TOTAL8:int = 25;
		public static const BET_TOTAL9:int = 26;
		public static const BET_TOTAL10:int = 27;
		public static const BET_TOTAL11:int = 28;
		public static const BET_TOTAL12:int = 29;
		public static const BET_TOTAL13:int = 30;
		public static const BET_TOTAL14:int = 31;
		public static const BET_TOTAL15:int = 32;
		public static const BET_TOTAL16:int = 33;
		public static const BET_TOTAL17:int = 34;
		// DOUBLES, TRIPPLES, HALF_BOARD bets
		public static const BET_DOUBLE1:int = 35; 
		public static const BET_DOUBLE2:int = 36; 
		public static const BET_DOUBLE3:int = 37; 
		public static const BET_DOUBLE4:int = 38; 
		public static const BET_DOUBLE5:int = 39; 
		public static const BET_DOUBLE6:int = 40; 
		public static const BET_TRIPLE1:int = 41; 
		public static const BET_TRIPLE2:int = 42; 
		public static const BET_TRIPLE3:int = 43; 
		public static const BET_TRIPLE4:int = 44; 
		public static const BET_TRIPLE5:int = 45; 
		public static const BET_TRIPLE6:int = 46; 
		public static const BET_ANYTRIPLE:int = 47; 
		public static const BET_SMALL:int = 48; 
		public static const BET_BIG:int = 49;
		public static const TOTAL_BETS:int = 50;

		public static const BET_PAYOUTS:Array = new Array(
			// single number bets
			1, 1, 1, 1, 1, 1,
			// pair combination bets
			5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
			// roll Total bets
			50, 18, 14, 12,	8, 6, 6, 6, 6, 8, 12, 14, 18, 50,
			// DOUBLES, TRIPPLES, HALF_BOARD bets
			8, 8, 8, 8, 8, 8,
			150, 150, 150, 150, 150, 150, 
			24, 1, 1
		);

		public static const BET_LABELS:Array = new Array(
			// single number bets
			"One", "Two", "Three", "Four", "Five", "Six",
			// pair combination bets
			"Combo 1,2", "Combo 1,3", "Combo 1,4", "Combo 1,5", "Combo 1,6",
			"Combo 2,3", "Combo 2,4", "Combo 2,5", "Combo 2,6",
			"Combo 3,4", "Combo 3,5", "Combo 3,6",
			"Combo 4,5", "Combo 4,6", "Combo 5,6",
			// roll Total bets
			"Total 4", "Total 5", "Total 6", "Total 7",	"Total 8", 
			"Total 9", "Total 10", "Total 11", "Total 12", "Total 13",
			"Total 14", "Total 15", "Total 16", "Total 17",
			// DOUBLES, TRIPPLES, HALF_BOARD bets
			"Double 1", "Double 2", "Double 3", 
			"Double 4", "Double 5", "Double 6",
			"Triple 1", "Triple 2", "Triple 3", 
			"Triple 4", "Triple 5", "Triple 6", 
			"Any Triple", "Small", "Big"
		);

		// ***** VARIABLES ***************************************************
		
		protected var _lights:Array;
		protected var _bets:Array;
		protected var _results:Array;
		protected var _soundDice:Sound;
		// note that all _*_movie, _*_btn and _*_txt variables are in movie

		protected var _betID:int;
//		protected var _betAmount:int;
		protected var _balance:int;

		protected var _soundFlag:Boolean;
		protected var _soundTransformOn:SoundTransform;
		protected var _soundTransformOff:SoundTransform;
		
		// ***** CONSTRUCTOR *************************************************

		public function SicBo()
		{
			_results = new Array(TOTAL_BETS);
			_balance = 0;
			_betID = 0;
			_lights = new Array(
				// single number bets
				_light_bet_1_movie, _light_bet_2_movie, _light_bet_3_movie,
				_light_bet_4_movie, _light_bet_5_movie, _light_bet_6_movie,
				// pair combination bets
				_light_bet_combo12_movie, _light_bet_combo13_movie, 
				_light_bet_combo14_movie, _light_bet_combo15_movie, 
				_light_bet_combo16_movie, _light_bet_combo23_movie, 
				_light_bet_combo24_movie, _light_bet_combo25_movie, 
				_light_bet_combo26_movie, _light_bet_combo34_movie, 
				_light_bet_combo35_movie, _light_bet_combo36_movie, 
				_light_bet_combo45_movie, _light_bet_combo46_movie, 
				_light_bet_combo56_movie,
				// roll Total bets
				_light_bet_total4_movie, _light_bet_total5_movie,
				_light_bet_total6_movie, _light_bet_total7_movie,
				_light_bet_total8_movie, _light_bet_total9_movie,
				_light_bet_total10_movie, _light_bet_total11_movie,
				_light_bet_total12_movie, _light_bet_total13_movie,
				_light_bet_total14_movie, _light_bet_total15_movie,
				_light_bet_total16_movie, _light_bet_total17_movie,
				// DOUBLES, TRIPPLES, HALF_BOARD bets
				_light_bet_double1_movie, _light_bet_double2_movie,
				_light_bet_double3_movie, _light_bet_double4_movie,
				_light_bet_double5_movie, _light_bet_double6_movie,
				_light_bet_triple1_movie, _light_bet_triple2_movie,
				_light_bet_triple3_movie, _light_bet_triple4_movie,
				_light_bet_triple5_movie, _light_bet_triple6_movie,
				_light_bet_anytriple_movie, 				
				_light_bet_small_movie, _light_bet_big_movie
			);

			_bets = new Array(
				// single number bets
				_bet_1_movie, _bet_2_movie, _bet_3_movie,
				_bet_4_movie, _bet_5_movie, _bet_6_movie,
				// pair combination bets
				_bet_combo12_movie, _bet_combo13_movie, 
				_bet_combo14_movie, _bet_combo15_movie, 
				_bet_combo16_movie, _bet_combo23_movie, 
				_bet_combo24_movie, _bet_combo25_movie, 
				_bet_combo26_movie, _bet_combo34_movie, 
				_bet_combo35_movie, _bet_combo36_movie, 
				_bet_combo45_movie, _bet_combo46_movie, 
				_bet_combo56_movie,
				// roll Total bets
				_bet_total4_movie, _bet_total5_movie,
				_bet_total6_movie, _bet_total7_movie,
				_bet_total8_movie, _bet_total9_movie,
				_bet_total10_movie, _bet_total11_movie,
				_bet_total12_movie, _bet_total13_movie,
				_bet_total14_movie, _bet_total15_movie,
				_bet_total16_movie, _bet_total17_movie,
				// DOUBLES, TRIPPLES, HALF_BOARD bets
				_bet_double1_movie, _bet_double2_movie,
				_bet_double3_movie, _bet_double4_movie,
				_bet_double5_movie, _bet_double6_movie,
				_bet_triple1_movie, _bet_triple2_movie,
				_bet_triple3_movie, _bet_triple4_movie,
				_bet_triple5_movie, _bet_triple6_movie,
				_bet_anytriple_movie,
				_bet_small_movie, _bet_big_movie
			);
			_soundDice = new dice3_wav();
			_soundFlag = false;
			_soundTransformOn = new SoundTransform(1, 0);
			_soundTransformOff = new SoundTransform(0, 0);
			SoundMixer.soundTransform = _soundTransformOff;
			_soundon_btn.visible = false;
			_soundoff_btn.visible = true;
			_soundon_btn.addEventListener(
					flash.events.MouseEvent.MOUSE_UP, handleSoundToggle);
			_soundoff_btn.addEventListener(
					flash.events.MouseEvent.MOUSE_UP, handleSoundToggle);
			_roll_btn.addEventListener(
					flash.events.MouseEvent.MOUSE_UP, handleRoll);

			for (var cntr:int = 0; cntr < TOTAL_BETS; ++cntr) {
				_bets[cntr].setID(cntr);
				_bets[cntr].addEventListener(
					flash.events.MouseEvent.MOUSE_UP, handleBet);	
				_bets[cntr].setBet(0);
				_lights[cntr].setID(cntr);
				_lights[cntr].addEventListener(
					flash.events.MouseEvent.MOUSE_UP, handleBet);	
				_lights[cntr].changeState(1);
			}
			_betPopup_movie.addEventListener(
					BetPopup.BET_EVENT, processBet);
			_betPopup_movie.visible = false;
//			changeState(STATE_STARTING);
			stop();
		}

		// ***** Functions - Event handlers **********************************

		public function handleRoll(evt:MouseEvent)
		{
			_die1_movie.quickRoll();
			_die2_movie.quickRoll();
			_die3_movie.quickRoll();
			_soundDice.play();
			processRoll();
		}

		public function handleBet(evt:MouseEvent)
		{
			_betID = evt.currentTarget.getID();
			_betPopup_movie.setBetName(BET_LABELS[_betID]);
			_betPopup_movie.setBet(_bets[_betID].getBet());
			_betPopup_movie.visible = true;
		}
		
		public function processBet(evt:Event)
		{
			_betPopup_movie.visible = false;
			var betAmount:int = _betPopup_movie.getLastBet();
			_balance += _bets[_betID].getBet();
			_balance -= betAmount;
			_bets[_betID].setBet(betAmount);
			_round_txt.text = "Balance " + _balance;
		}

		public function handleSoundToggle(evt:Event)
		{
			if (_soundFlag) {
				SoundMixer.soundTransform = _soundTransformOff;
			} else {
				SoundMixer.soundTransform = _soundTransformOn;
			}
			_soundFlag = !_soundFlag;
			_soundon_btn.visible = _soundFlag;
			_soundoff_btn.visible = !_soundFlag;
		}

// ***************************************
// ***** Functions - General control *****
// ***************************************

		public function processRoll()
		{
			var d1:int = _die1_movie.getValue();
			var d2:int = _die2_movie.getValue();
			var d3:int = _die3_movie.getValue();
			var cntr:int;
			
			// clear out the previous results
			for (cntr = 0; cntr < TOTAL_BETS; ++cntr)
				_results[cntr] = 0;
			// handle single number bets
			++_results[BET_1 + d1 - 1];
			++_results[BET_1 + d2 - 1];
			++_results[BET_1 + d3 - 1];
			
			// handle the combo bets
			processCombo(d1, d2);
			processCombo(d1, d3);
			processCombo(d2, d3);
			
			// handle the totals bets
			var total:int = d1 + d2 + d3;
			if ((total > 3) && (total < 18))
				++_results[BET_TOTAL4 + total - 4];

			// double, tripple, and half board bets
			if ((d1 == d2) && (d2 == d3)) {
				++_results[BET_ANYTRIPLE];
				++_results[BET_TRIPLE1 + d1 - 1];
			} else {
				if (d1 == d2)
					++_results[BET_DOUBLE1 + d1 - 1];
				if (d1 == d3)
					++_results[BET_DOUBLE1 + d1 - 1];
				if (d2 == d3)
					++_results[BET_DOUBLE1 + d2 - 1];
				if (total < 11)
					++_results[BET_SMALL];
				else
					++_results[BET_BIG];
			}
			
			var betAmount:int;
			for (cntr = 0; cntr < TOTAL_BETS; ++cntr) {
				betAmount = _bets[cntr].getBet();
				if (_results[cntr] > 0) {
					_lights[cntr].changeState(BackLight.STATE_ON);
					if (betAmount > 0)
						_balance += (BET_PAYOUTS[_betID] * 
								betAmount * _results[_betID] + betAmount);
				} else
					_lights[cntr].changeState(BackLight.STATE_DIM);
				_balance -= betAmount; // auto placement of bets
			}
			_round_txt.text = "Balance " + _balance;
		}

		protected function processCombo(d1:int, d2:int)
		{
			if (d1 == d2)
				return;
			var low:int = Math.min(d1, d2);
			var high:int = Math.max(d1, d2);
			
			switch (low) {
			case 1:
				++_results[BET_COMBO12 + high - 2];
				break;
			case 2:
				++_results[BET_COMBO23 + high - 3];
				break;
			case 3:
				++_results[BET_COMBO34 + high - 4];
				break;
			case 4:
				++_results[BET_COMBO45 + high - 5];
				break;
			case 5:
				++_results[BET_COMBO56];
				break;
			}
		}

	} // end class
} // end package

