/* Dozen Days of Tiles Common Library
 * Developed by Billy D. Spelchan
 * Copyright (c) 2011 Blazing Games Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

// $$$ REQUIRES BGLayers
// Create the namespace for this library
var DDT = new Object();

// --------------------------------------------------------------------------

DDT.ImageButton = function(id, img, width, height, isvertacle)
{
	this._image = img;	
	if (arguments.length == 2) { // clickable image
		this._disabledRect = new BGLayers.Rectangle(0,0, img.width, img.height);
		this._normalRect = new BGLayers.Rectangle(0,0, img.width, img.height);
		this._overRect = new BGLayers.Rectangle(0,0, img.width, img.height);
		this._downRect = new BGLayers.Rectangle(0,0, img.width, img.height);
	} else {
		var hv = true
		if (arguments.length == 5)
			hv = isvertacle;
		if (hv == true) {
			this._disabledRect = new BGLayers.Rectangle(0,0, width, height);
			this._normalRect = new BGLayers.Rectangle(0,0+height, width, height);
			this._overRect = new BGLayers.Rectangle(0,0+2*height, width, height);
			this._downRect = new BGLayers.Rectangle(0,0+3*height, width, height);
		} else {
			this._disabledRect = new BGLayers.Rectangle(0,0, width, height);
			this._normalRect = new BGLayers.Rectangle(0+width,0, width, height);
			this._overRect = new BGLayers.Rectangle(0+2*width,0, width, height);
			this._downRect = new BGLayers.Rectangle(0+3*width,0, width, height);
		}
	}
	this.buttonstate = 1;
	this.onClick = null;

	this.BUTTONSTATE_DISABLED = 0;
	this.BUTTONSTATE_NORMAL = 1;
	this.BUTTONSTATE_OVER = 2;
	this.BUTTONSTATE_DOWN = 3;
	
	this.supr = new BGLayers.Layer(id, this._disabledRect.width, this._disabledRect.height);
	BGLayers.inheritProperties(this, this.supr);
}

DDT.ImageButton.prototype.setClips = function(xrect,nrect,orect,drect)
{
	this._disabledRect = xrect;
	this._normalRect = nrect;
	this._overRect = orect;
	this._downRect = drect;
}

DDT.ImageButton.prototype.mouseDown = function(x, y)
{
	var oldState = this.buttonstate;
	if (this.buttonstate != this.BUTTONSTATE_DISABLED) {
		var over = this.findRealPosition().containsPoint(x,y);
		if (over)
			this.buttonstate = this.BUTTONSTATE_DOWN;
	}

	var dirty = (oldState != this.buttonstate);
	if (dirty)
		this.addDirty(new BGLayers.Rectangle(this.findRealPosition()));	
	return dirty;
}

DDT.ImageButton.prototype.mouseMove = function(x, y)
{
	var oldState = this.buttonstate;

	if ( (this.buttonstate != this.BUTTONSTATE_DISABLED) &&
			(this.buttonstate != this.BUTTONSTATE_DOWN) ) {
		var over = this.findRealPosition().containsPoint(x,y);
		if (over)
			this.buttonstate = this.BUTTONSTATE_OVER;
		else
			this.buttonstate = this.BUTTONSTATE_NORMAL;
	}

	var dirty = (oldState != this.buttonstate);
	if (dirty)
		this.addDirty(new BGLayers.Rectangle(this.findRealPosition()));	
	return dirty;
}

DDT.ImageButton.prototype.mouseUp = function(x, y)
{
	var oldState = this.buttonstate;

	if ( (this.buttonstate == this.BUTTONSTATE_DOWN) && 
			(this.onClick != null) ) {
		var over = this.findRealPosition().containsPoint(x,y);
		if ((over) && (this.onClick != null))
			this.onClick.buttonClicked(this);
	}
	if (this.buttonstate != this.BUTTONSTATE_DISABLED) 
		this.buttonstate = this.BUTTONSTATE_NORMAL;
	
	var dirty = (oldState != this.buttonstate);
	if (dirty)
		this.addDirty(new BGLayers.Rectangle(this.findRealPosition()));	
	return dirty;
}


DDT.ImageButton.prototype.drawSelf = function(ctx, bounds)
{
	if (this.findRealPosition().intersects(bounds) == false)
		return;
	var clip = this._disabledRect;
	switch (this.buttonstate) {
		case this.BUTTONSTATE_NORMAL:
			clip = this._normalRect;
			break;
		case this.BUTTONSTATE_OVER:
			clip = this._overRect;
			break;
		case this.BUTTONSTATE_DOWN:
			clip = this._downRect;
			break;
	}
	var rect = this._realPosition.getIntersection(bounds);
	var scaleX = clip.width / this._realPosition.width;
	var scaleY = clip.height / this._realPosition.height;
	var boundClip = new BGLayers.Rectangle(
				clip.x + (rect.x - this._realPosition.x) * scaleX,
				clip.y + (rect.y - this._realPosition.y) * scaleY,
				rect.width * scaleX,
				rect.height * scaleY);
	ctx.drawImage(this._image, boundClip.x, boundClip.y, boundClip.width, boundClip.height,
				rect.x, rect.y, rect.width, rect.height);
}

DDT.ImageButton.prototype.setDisabled = function(b)
{
	if (!b)
		this.buttonstate = this.BUTTONSTATE_NORMAL;
	else
		this.buttonstate = this.BUTTONSTATE_DISABLED;
	this.addDirty(new BGLayers.Rectangle(this.findRealPosition()));	
}

// --------------------------------------------------------------------------

DDT.ImageCheckBox = function(id, img, width, height, ischecked)
{
	this.supr = new DDT.ImageButton(id,img,width,height);
	BGLayers.inheritProperties(this, this.supr);

	this._checked = false;
	if (arguments.length == 5)
		this._checked = ischecked;

	this._disabledRectChecked = new BGLayers.Rectangle(width,0, width, height);
	this._normalRectChecked = new BGLayers.Rectangle(width,height, width, height);
	this._overRectChecked = new BGLayers.Rectangle(width,height*2, width, height);
	this._downRectChecked = new BGLayers.Rectangle(width,height*3, width, height);
}


DDT.ImageCheckBox.prototype.setCheckedClips = function(xrect,nrect,orect,drect)
{
	this._disabledRectChecked = xrect;
	this._normalRectChecked = nrect;
	this._overRectChecked = orect;
	this._downRectChecked = drect;
}

DDT.ImageCheckBox.prototype.mouseUp = function(x, y)
{
	var oldState = this.buttonstate;

	if ( (this.buttonstate == this.BUTTONSTATE_DOWN) && 
			(this.onClick != null) ) {
		var over = this.findRealPosition().containsPoint(x,y);
		if (over) {
			this._checked = ! this._checked;
			if (this.onClick != null)
				this.onClick.checkboxClicked(this);
		}
	}
	if (this.buttonstate != this.BUTTONSTATE_DISABLED) 
		this.buttonstate = this.BUTTONSTATE_NORMAL;
	
	var dirty = (oldState != this.buttonstate);
	if (dirty)
		this.addDirty(new BGLayers.Rectangle(this.findRealPosition()));	
	return dirty;
}


DDT.ImageCheckBox.prototype.drawSelf = function(ctx, bounds)
{
	if (this.findRealPosition().intersects(bounds) == false)
		return;
	var clip = this._disabledRect;
	switch (this.buttonstate) {
		case this.BUTTONSTATE_DISABLED:
			if (this._checked)
				clip = this._disabledRectChecked;
			else
				clip = this._disabledRect;
			break;
		case this.BUTTONSTATE_NORMAL:
			if (this._checked)
				clip = this._normalRectChecked;
			else
				clip = this._normalRect;
			break;
		case this.BUTTONSTATE_OVER:
			if (this._checked)
				clip = this._overRectChecked;
			else
				clip = this._overRect;
			break;
		case this.BUTTONSTATE_DOWN:
			if (this._checked)
				clip = this._downRectChecked;
			else
				clip = this._downRect;
			break;
	}
	var rect = this._realPosition.getIntersection(bounds);
	var scaleX = clip.width / this._realPosition.width;
	var scaleY = clip.height / this._realPosition.height;
	var boundClip = new BGLayers.Rectangle(
				clip.x + (rect.x - this._realPosition.x) * scaleX,
				clip.y + (rect.y - this._realPosition.y) * scaleY,
				rect.width * scaleX,
				rect.height * scaleY);
	ctx.drawImage(this._image, boundClip.x, boundClip.y, boundClip.width, boundClip.height,
				rect.x, rect.y, rect.width, rect.height);
}

DDT.ImageCheckBox.prototype.isChecked = function()
{
	return this._checked;
}

DDT.ImageCheckBox.prototype.setChecked = function(b)
{
	this._checked = b;
	this.addDirty(new BGLayers.Rectangle(this.findRealPosition()));		
}

// --------------------------------------------------------------------------

/**
* @class Holds color information for GUI components
*/
DDT.ColorSet = function()
{
	this.disabledBackground = '#555555';
	this.disabledBackShadow = '#222222';
	this.disabledBackHighlight = '#888888';
	this.disabledText = '#000000';

	this.normalBackground = '#0000CC';
	this.normalBackShadow = '#000080';
	this.normalBackHighlight = '#5555CC';
	this.normalText = '#FFFFFF';

	this.overBackground = '#00CCCC';
	this.overBackShadow = '#008080';
	this.overBackHighlight = '#55CCCC';
	this.overText = '#FFFFFF';


	this.downBackground = '#CC00CC';
	this.downBackShadow = '#800080';
	this.downBackHighlight = '#CC55CC';
	this.downText = '#80FFFF';
	
}

//DDT.DEFAULT_COLOR_SET = new DDT.ColorSet();

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

