/* Dozen Days of Tiles episode 1 - Sudoku Player
 * Developed by Billy D. Spelchan
 * Copyright (c) 2011 Blazing Games Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
// Create the namespace for this library
var Sudoku = new Object();

Sudoku.sudokuTiles = new Image();
Sudoku.sudokuTiles.src = 'sudoku_number_tiles.gif';
Sudoku.sudokuBackdrop = new Image();
Sudoku.sudokuBackdrop.src = 'sudokuBackdrop.jpg';
Sudoku.checkbox_img = new Image();
Sudoku.checkbox_img.src = 'checkbox.gif';
Sudoku.showMistakes_img = new Image();
Sudoku.showMistakes_img.src = 'showMistakes.gif';
Sudoku.clearNotes_img = new Image();
Sudoku.clearNotes_img.src = 'clearNotes.gif';
Sudoku.hint_img = new Image();
Sudoku.hint_img.src = 'hint.gif';
Sudoku.check_img = new Image();;
Sudoku.check_img.src = 'check.gif';

// --------------------------------------------------------------------------

Sudoku.Tile = function(id)
{
	this.supr = new BGLayers.Layer(id, 40, 40);
	BGLayers.inheritProperties(this, this.supr);
	
	this.tileID = 0;
	this.state = 2;
	this.checkmarkA = new Array(false,false,false,false,false,false,false,false,false,false);
	this.checkmarkB = new Array(false,false,false,false,false,false,false,false,false,false);
	this.tileImage = new BGLayers.ImageLayer("tile", Sudoku.sudokuTiles);
	this._tileClip = new BGLayers.Rectangle(0,0,40,40);
	this.tileImage.setClip(this._tileClip);
	this.addChild(this.tileImage, new BGLayers.Rectangle(0,0,40,40));

	this.hints = new Array();
	this._hintsClip = new Array();
	var subX, subY;
	this.hints[0] = this.tileImage;
	for (var cntr = 1; cntr < 10; ++cntr) {
		this.hints[cntr] = new BGLayers.ImageLayer("hint"+cntr, Sudoku.sudokuTiles);
		this._hintsClip[cntr] = new BGLayers.Rectangle(cntr*40,0,40,40)
		this.hints[cntr].setClip(this._hintsClip[cntr]);
		subX = ((cntr - 1) % 3) * 12 + 3;
		subY = Math.floor((cntr - 1) / 3) * 12 + 3;
		this.addChild(this.hints[cntr], new BGLayers.Rectangle(subX,subY,10,10));
		this.hints[cntr].setVisible(false);
	}
}

Sudoku.Tile.STATE_ERROR = 0;
Sudoku.Tile.STATE_HINT = 1;
Sudoku.Tile.STATE_NORMAL = 2;
Sudoku.Tile.STATE_LOCKED = 3;

Sudoku.Tile.prototype.updateUI = function()
{
	this._tileClip.x = this.tileID * 40;
	this._tileClip.y = this.state * 40;
	this.tileImage.setClip(this._tileClip);
	var showNotes = (this.tileID == 0);
	for (var cntr = 1; cntr < 10; ++cntr) {
		this._hintsClip[cntr].y = this.checkmarkA[cntr] ? 
			(this.checkmarkB[cntr] ? 0 : 80) :
			(this.checkmarkB[cntr] ? 40 : 160); 
		this.hints[cntr].setClip(this._hintsClip[cntr]);
		if (this._hintsClip[cntr].y == 160)
			this.hints[cntr].setVisible(false);
		else
			this.hints[cntr].setVisible(showNotes);
	}
}

Sudoku.Tile.prototype.setCheck = function(group, indx, b)
{
	if (group == 0)
		this.checkmarkA[indx] = b;
	else
		this.checkmarkB[indx] = b;
	this.updateUI();

}

Sudoku.Tile.prototype.getCheck = function(group, indx)
{
	if (group == 0)
		return this.checkmarkA[indx];
	else
		return this.checkmarkB[indx];
}

Sudoku.Tile.prototype.setValue = function(tileID)
{
	this.tileID = tileID;
	this.updateUI();
}

Sudoku.Tile.prototype.getValue = function()
{
	return this.tileID;
}

Sudoku.Tile.prototype.setState = function(state)
{
	this.state = state;
	this.updateUI();
}

Sudoku.Tile.prototype.getState = function()
{
	return this.state;
}

Sudoku.Tile.prototype.isLocked = function()
{
	return (this.state == Sudoku.Tile.STATE_LOCKED);
}

Sudoku.Tile.prototype.mouseUp = function(x, y)
{
	var over = this.findRealPosition().containsPoint(x,y);
	if (over) {
		if (this.onClick != null)
			this.onClick.tileClicked(this);
	}
	return true; //dirty;
}

// --------------------------------------------------------------------------

Sudoku.SideBar = function(id, player)
{
	this.supr = new BGLayers.Layer(id, 200, 480);
	BGLayers.inheritProperties(this, this.supr);
	this._solid = false;
	
	this.player = player;
	this.tile = null;
	
	this.showMistakes_cbx = new DDT.ImageCheckBox('sm', Sudoku.showMistakes_img, 160,25, true);
	this.showMistakes_cbx.onClick = this;
	this.addChild(this.showMistakes_cbx, new BGLayers.Rectangle(10,10,160,25));

	this.clearNotes_btn = new DDT.ImageButton('clear', Sudoku.clearNotes_img, 160,25);
	this.clearNotes_btn.onClick = this;
	this.addChild(this.clearNotes_btn, new BGLayers.Rectangle(10,360,160,25));

	this.hint_btn = new DDT.ImageButton('hint', Sudoku.hint_img, 160,25);
	this.hint_btn.onClick = this;
	this.addChild(this.hint_btn, new BGLayers.Rectangle(10,400,160,25));

	this.check_btn = new DDT.ImageButton('check', Sudoku.check_img, 160,25);
	this.check_btn.onClick = this;
	this.addChild(this.check_btn, new BGLayers.Rectangle(10,430,160,25));
	
	this.lockedTile = new Sudoku.Tile('locked');
	this.addChild(this.lockedTile, new BGLayers.Rectangle(30,80,120,120));
	
	var cntr;
	this.tileIcons = new Array(10);
	this.checkABoxes = new Array(10);
	this.checkBBoxes = new Array(10);
	for (cntr = 1; cntr < 10; ++cntr)
	{
		this.tileIcons[cntr] = new Sudoku.Tile('icon'+cntr);
		this.tileIcons[cntr].setValue(cntr);
		this.tileIcons[cntr].setState(Sudoku.Tile.STATE_NORMAL);
		this.tileIcons[cntr].onClick = this;
		this.addChild(this.tileIcons[cntr], new BGLayers.Rectangle(30,50+30*cntr,30,30));

		this.checkABoxes[cntr] = new DDT.ImageCheckBox('cbxA'+cntr, Sudoku.checkbox_img, 20, 20, false);
		this.checkABoxes[cntr].onClick = this;
		this.addChild(this.checkABoxes[cntr], new BGLayers.Rectangle(90,50+30*cntr,20,20));

		this.checkBBoxes[cntr] = new DDT.ImageCheckBox('cbxB'+cntr, Sudoku.checkbox_img, 20, 20, false);
		this.checkBBoxes[cntr].onClick = this;
		this.addChild(this.checkBBoxes[cntr], new BGLayers.Rectangle(130,50+30*cntr,20,20));
	}
}

Sudoku.SideBar.prototype.setActiveTile = function(tile)
{
	this.tile = tile;
	this.updateUI();
}

Sudoku.SideBar.prototype.updateUI = function()
{
	var cntr;
	var locked = false
	
	this.lockedTile.setVisible(false);
	if (this.tile == null) {
		locked = true;
	}
	else if (this.tile.isLocked()) {
		this.lockedTile.setVisible(true);
		this.lockedTile.setValue(this.tile.getValue());
		locked = true;
	}
	
	for (cntr = 1; cntr < 10; ++cntr)
	{
		this.tileIcons[cntr].setVisible(!locked);
		this.checkABoxes[cntr].setVisible(!locked);
		this.checkBBoxes[cntr].setVisible(!locked);
	}	
	this.clearNotes_btn.setDisabled(locked);
	this.hint_btn.setDisabled(locked);
	this.check_btn.setDisabled(locked);
	
	if (!locked) {
		for (cntr = 1; cntr < 10; ++cntr)
		{
			this.checkABoxes[cntr].setChecked(this.tile.getCheck(0,cntr));
			this.checkBBoxes[cntr].setChecked(this.tile.getCheck(1,cntr));
		}
	}
}

Sudoku.SideBar.prototype.buttonClicked = function(btn)
{	
	if (btn.id == 'clear') {
		for (var cntr = 1; cntr < 10; ++cntr) {
			this.tile.setCheck(0, cntr, false);
			this.tile.setCheck(1, cntr, false);
		}
		this.setActiveTile(this.tile);
	} else if (btn.id == 'hint') {
		this.player.view.setTileHints(this.tile);
		this.setActiveTile(this.tile);
	} else if (btn.id == 'check') {
		this.player.view.checkValidTile(this.tile);
		this.setActiveTile(this.tile);
	}
}

Sudoku.SideBar.prototype.checkboxClicked = function(cbx)
{
	if (cbx.id == 'sm') {
		this.player.view.enableHintMode(cbx.isChecked());
	} else {
		var group = 0;
		if (cbx.id.search(/cbxB/) > -1)
			group = 1;
		var num = cbx.id.substring(4);
		this.tile.setCheck(group, num, cbx.isChecked());
	}
}

Sudoku.SideBar.prototype.tileClicked = function(tile)
{
	this.tile.setValue(tile.getValue());
	this.player.view.updateHints();
}


// --------------------------------------------------------------------------

Sudoku.SudokuView = function(id,player)
{
	this.supr = new BGLayers.Layer(id, 440, 440);
	BGLayers.inheritProperties(this, this.supr);
	this.player = player;
	this._solid = false;

	this.tileGrid = new Array(10);
	var tempTile, tempX, tempY;
	for (var cntrRow = 1; cntrRow < 10; ++cntrRow) {
		this.tileGrid[cntrRow] = new Array(10);
		tempY = cntrRow * 43 + Math.floor((cntrRow - 1) / 3) * 10 - 27;
		for (var cntrCol = 1; cntrCol < 10; ++cntrCol) {
			tempX = cntrCol * 43 + Math.floor((cntrCol - 1) / 3) * 10 - 27;
			tempTile = new Sudoku.Tile(""+(cntrRow*10+cntrCol));
			tempTile.onClick = this;
			this.addChild(tempTile, new BGLayers.Rectangle(tempX, tempY, 40,40));
			this.tileGrid[cntrRow][cntrCol] = tempTile;
		}
	}
	
	this._tileSelected = null;
	this._selectLeft = new BGLayers.Layer('sl',3,40);
	this.addChild(this._selectLeft, new BGLayers.Rectangle(0,0,3,40));
	this._selectLeft.setBackgroundColor("yellow");
	this._selectLeft.setVisible(false);

	this._selectTop = new BGLayers.Layer('st', 40,3);
	this.addChild(this._selectTop, new BGLayers.Rectangle(0,0,40,3));
	this._selectTop.setBackgroundColor("yellow");
	this._selectTop.setVisible(false);

	this._selectRight = new BGLayers.Layer('sr', 3,40);
	this.addChild(this._selectRight, new BGLayers.Rectangle(37,0,3,40));
	this._selectRight.setBackgroundColor("gold");
	this._selectRight.setVisible(false);

	this._selectBottom = new BGLayers.Layer('sb', 40,3);
	this.addChild(this._selectBottom, new BGLayers.Rectangle(0,37,40,3));
	this._selectBottom.setBackgroundColor("gold");
	this._selectBottom.setVisible(false);

	this._hintMode = true;	
}

Sudoku.SudokuView.prototype.tileClicked = function(tile)
{
	this._tileSelected = tile;
	
	var temp = tile.getPosition();
	this._selectLeft.moveTo(temp.x, temp.y);
	this._selectLeft.setVisible(true);

	this._selectTop.moveTo(temp.x, temp.y);
	this._selectTop.setVisible(true);

	this._selectRight.moveTo(temp.x+37, temp.y);
	this._selectRight.setVisible(true);

	this._selectBottom.moveTo(temp.x, temp.y+37);
	this._selectBottom.setVisible(true);
	
	this.player.selectTile(tile);
}

Sudoku.SudokuView.prototype.checkRowForValue = function(r, n)
{
	var cntrCol;
	var foundCount = 0;
	
	for (cntrCol = 1; cntrCol < 10; ++cntrCol)
		if (this.tileGrid[r][cntrCol].getValue() == n)
			++foundCount;

	return foundCount;
}

Sudoku.SudokuView.prototype.checkColForValue = function(c, n)
{
	var cntrRow;
	var foundCount = 0;
	
	for (cntrRow = 1; cntrRow < 10; ++cntrRow)
		if (this.tileGrid[cntrRow][c].getValue() == n)
			++foundCount;

	return foundCount;
}

Sudoku.SudokuView.prototype.checkGroupForValue = function(g, n)
{
	var cntrRow, cntrCol;
	var foundCount = 0;
	var rowOffset = Math.floor((g-1) / 3) * 3;
	var colOffset = Math.floor((g-1) % 3) * 3;
	for (cntrRow = 1; cntrRow < 4; ++cntrRow)
		for (cntrCol = 1; cntrCol < 4; ++cntrCol)
			if (this.tileGrid[rowOffset+cntrRow][colOffset+cntrCol].getValue() == n)
				++foundCount;

	return foundCount;
}

Sudoku.SudokuView.prototype.enableHintMode = function(b)
{
	this._hintMode = b;
	if (b) 
		this.updateHints();
	else {
		var cntrRow, cntrCol;
		for (cntrRow = 1; cntrRow < 10; ++cntrRow)
			for (cntrCol = 1; cntrCol < 10; ++cntrCol)
				if ( ! this.tileGrid[cntrRow][cntrCol].isLocked())
					this.tileGrid[cntrRow][cntrCol].setState(Sudoku.Tile.STATE_NORMAL);
	}
}

Sudoku.SudokuView.prototype.updateHints = function()
{
	if (! this._hintMode)
		return;
	var cntrRow, cntrCol, tempVal, tempCount, group ;
	var rc, cc, gc;
	for (cntrRow = 1; cntrRow < 10; ++cntrRow)
		for (cntrCol = 1; cntrCol < 10; ++cntrCol)
		if ( this.tileGrid[cntrRow][cntrCol].isLocked() == false) {
			group = Math.floor((cntrRow-1)/3) * 3 + Math.floor((cntrCol-1)/3) + 1;
			tempVal = this.tileGrid[cntrRow][cntrCol].getValue();
			rc = this.checkRowForValue(cntrRow, tempVal);
			cc = this.checkColForValue(cntrCol, tempVal);
			gc = this.checkGroupForValue(group, tempVal);
			tempCount = rc+cc+gc;
			this.tileGrid[cntrRow][cntrCol].setState(tempCount > 3 ? Sudoku.Tile.STATE_ERROR : Sudoku.Tile.STATE_HINT);
		}
}

Sudoku.SudokuView.prototype.setTileHints = function(tile)
{
	var tileRow = Math.floor(tile.id / 10);
	var tileCol = Math.floor(tile.id % 10);
	var tileGroup = Math.floor((tileRow-1)/3) * 3 + Math.floor((tileCol-1)/3) + 1;
	var tempVal, rc, cc, gc;
	for (tempVal = 1; tempVal < 10; ++tempVal) {
		rc = this.checkRowForValue(tileRow, tempVal);
		cc = this.checkColForValue(tileCol, tempVal);
		gc = this.checkGroupForValue(tileGroup, tempVal);
		tile.setCheck (0, tempVal, ((rc+cc+gc) == 0));
	}
	
}

Sudoku.SudokuView.prototype.checkValidTile = function(tile)
{
	var tileRow = Math.floor(tile.id / 10);
	var tileCol = Math.floor(tile.id % 10);
	var tileGroup = Math.floor((tileRow-1)/3) * 3 + Math.floor((tileCol-1)/3) + 1;
	var tempVal, rc, cc, gc;
	tempVal = tile.getValue();
	rc = this.checkRowForValue(tileRow, tempVal);
	cc = this.checkColForValue(tileCol, tempVal);
	gc = this.checkGroupForValue(tileGroup, tempVal);
	if ((rc+cc+gc) > 3) {
		tile.setValue(0);
		this.setTileHints(tile);
	}
}

Sudoku.SudokuView.prototype.setPuzzle = function(data)
{
	for (cntrRow = 1; cntrRow < 10; ++cntrRow)
		for (cntrCol = 1; cntrCol < 10; ++cntrCol)
			if (data[cntrRow][cntrCol] > 10) {
				this.tileGrid[cntrRow][cntrCol].setValue(data[cntrRow][cntrCol]-10);
				this.tileGrid[cntrRow][cntrCol].setState(Sudoku.Tile.STATE_LOCKED);
			} else {
				this.tileGrid[cntrRow][cntrCol].setValue(0);
				this.tileGrid[cntrRow][cntrCol].setState(Sudoku.Tile.STATE_NORMAL);
			}
}

// --------------------------------------------------------------------------

Sudoku.Player = function()
{
	this.supr = new BGLayers.ImageLayer("SudokuPlayer", Sudoku.sudokuBackdrop);
	BGLayers.inheritProperties(this, this.supr);
	this.setBackgroundColor("#000088");
	this.view = new Sudoku.SudokuView('view', this);
	this.addChild(this.view, new BGLayers.Rectangle(0,20,440,440));
	this.sideBar = new Sudoku.SideBar('sideBar', this);
	this.sideBar.updateUI();
//	this.sideBar.setActiveTile(testTile);
	this.addChild(this.sideBar, new BGLayers.Rectangle(440,0,200,480));
}

Sudoku.Player.prototype.selectTile = function(tile)
{
	this.sideBar.setActiveTile(tile);
}

Sudoku.Player.prototype.setPuzzle = function(data)
{
	this.view.setPuzzle(data);
}

// --------------------------------------------------------------------------


