/*
Dozen Days of Words episode 8: Trivia Bomb
Copyright (c) 2009 Blazing Games Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
package
{
	import flash.display.MovieClip;
	import flash.events.*;
	import flash.text.TextField;
	import flash.ui.Keyboard;

	import com.blazinggames.dozendays.*;
	import com.blazinggames.dozendays.words.*;
	import com.blazinggames.dozendays.words.bomb.*;

	[SWF(width="640", height="480", backgroundColor="#000000")]
	
	public class TriviaBomb extends MovieClip implements IGameMode
	{
// ***** CONSTANTS ***********************************************************
		public static const PAGE1_TEXT:String = 
"This game was created for Blazing Games Inc. by Billy D. Spelchan "+
"(the person writing this).\n\n"+
"This game is part of the Dozen Days of Words series which is a collection of "+
"Games that are created in under 24 hours of working time that revolve around "+
"the creation of computer versions of word games. The seventh episode of "+
"Dozen Days of Words is a trivia game. It will be presented as a typical "+
"television game show. Players will play through 4 rounds where they choose "+
"from a list of categories and have to answer a number of questions before "+
"the timer (a bomb that has a buring fuse) runs out.";

		public static const PAGE2_TEXT:String = 
"This program is free software; you can redistribute it and/or modify "+
"it under the terms of the GNU General Public License as published by "+
"the Free Software Foundation; either version 2 of the License, or "+
"(at your option) any later version.\n\n"+
"This program is distributed in the hope that it will be useful, "+
"but WITHOUT ANY WARRANTY; without even the implied warranty of "+
"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the "+
"GNU General Public License for more details.\n\n"+
"You should have received a copy of the GNU General Public License "+
"along with this program; if not, write to the Free Software "+
"Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA";

		public static const MODE_NONE:int = 0;
		public static const MODE_TITLE:int = 1;
		public static const MODE_GAME:int = 2;
		public static const MODE_ABOUT:int = 3;

		public static const PUZZLE:XML = 
<DDWE8>
	<ROUND value='1'>
		<CARD id='1'>
			<CATEGORY>Astrology</CATEGORY>
			<QUESTION>People born on October 21st are given what sign?</QUESTION>
			<ANSWER>Libra</ANSWER>
			<ANSWER>Scorpio</ANSWER>
			<EXPLANATION>Libra runs from September 23rd to October 23rd</EXPLANATION>
		</CARD>
		<CARD id='2'>
			<CATEGORY>Television</CATEGORY>
			<QUESTION>Joss Whedon is the series creator of Buffy the Vampire Slayer</QUESTION>
			<ANSWER>True</ANSWER>
			<ANSWER>False</ANSWER>
			<EXPLANATION>While Firefly was a better series, Joss Whedon was the series creator and after the final seventh season he continued the series in comics/graphic novels.</EXPLANATION>
		</CARD>
		<CARD id='3'>
			<CATEGORY>Music</CATEGORY>
			<QUESTION>Trent Reznor is the man behind Nine Inch Nails</QUESTION>
			<ANSWER>True</ANSWER>
			<ANSWER>False</ANSWER>
			<EXPLANATION>Trent Reznor is the man behind Nine Inch Nails</EXPLANATION>
		</CARD>
		<CARD id='4'>
			<CATEGORY>Chemistry</CATEGORY>
			<QUESTION>AU is the period table symbol for Silver</QUESTION>
			<ANSWER>False</ANSWER>
			<ANSWER>True</ANSWER>
			<EXPLANATION>Gold is the element with the symbol AU.</EXPLANATION>
		</CARD>
		<CARD id='5'>
			<CATEGORY>Zoology</CATEGORY>
			<QUESTION>What family of animals do Humans belong to.</QUESTION>
			<ANSWER>Homo Sapiens</ANSWER>
			<ANSWER>Homo Superior</ANSWER>
			<EXPLANATION>Humans are an animal and belong to the Homo Sapiens (Wise Man) species</EXPLANATION>
		</CARD>
		<CARD id='6'>
			<CATEGORY>Numbers</CATEGORY>
			<QUESTION>PI is an irrational number</QUESTION>
			<ANSWER>True</ANSWER>
			<ANSWER>False</ANSWER>
			<EXPLANATION>An irrational number is one in which there are an infinite number of non-repeating decimal places, which is the case with PI</EXPLANATION>
		</CARD>
	</ROUND>
	<ROUND value='2'>
		<CARD id='1'>
			<CATEGORY>Programming</CATEGORY>
			<QUESTION>The tool used to convert program written in a high level language into machine language.</QUESTION>
			<ANSWER>Compiler</ANSWER>
			<ANSWER>Interpreter</ANSWER>
			<ANSWER>Obfuscater</ANSWER>
			<EXPLANATION>The Compiler is the tool that is used to convert a program written in a human understandable format into the binary format that computers understand. Note that virtual machines that many modern languages  compile into are also a form of machine language, just for a machine that doesn't necessarily exist.</EXPLANATION>
		</CARD>
		<CARD id='2'>
			<CATEGORY>History</CATEGORY>
			<QUESTION>Canada gained independence from England in what year?</QUESTION>
			<ANSWER>1867</ANSWER>
			<ANSWER>1812</ANSWER>
			<ANSWER>1984</ANSWER>
			<EXPLANATION>The British North America Act, brought about Confederation on July 1, 1867</EXPLANATION>
		</CARD>
		<CARD id='3'>
			<CATEGORY>Mathematics</CATEGORY>
			<QUESTION>An Equilateral triangle ... </QUESTION>
			<ANSWER>Has 3 equal length sides.</ANSWER>
			<ANSWER>Has a 90 degree angle.</ANSWER>
			<ANSWER>Has 3 different length sides.</ANSWER>
			<EXPLANATION>An Equilateral triangle as 3 equal length sides.</EXPLANATION>
		</CARD>
		<CARD id='4'>
			<CATEGORY>Video Games</CATEGORY>
			<QUESTION>Nintendo's Mario character was created by who?</QUESTION>
			<ANSWER>Shigeru Miyamoto</ANSWER>
			<ANSWER>text</ANSWER>
			<ANSWER>text</ANSWER>
			<EXPLANATION>Shigeru Miyamoto created mario as the player for Donkey Kong, his first game.</EXPLANATION>
		</CARD>
		<CARD id='5'>
			<CATEGORY>Internet</CATEGORY>
			<QUESTION>FTP is an acronym which stands for?</QUESTION>
			<ANSWER>File Transfer Protocol</ANSWER>
			<ANSWER>Fast Transfer Protocol</ANSWER>
			<ANSWER>Files To People</ANSWER>
			<EXPLANATION>File Transfer Protocol is the standard used for transferring files across the internet.</EXPLANATION>
		</CARD>
		<CARD id='6'>
			<CATEGORY>Open Source</CATEGORY>
			<QUESTION>The name of the person who started the Free Software Foundation</QUESTION>
			<ANSWER>Richard Stallman</ANSWER>
			<ANSWER>Peter Gabriel</ANSWER>
			<ANSWER>Trent Reznor</ANSWER>
			<EXPLANATION>In 1985 Richard Stallman started the Free Software Foundation to promote open source software, the GPL License, and his own GNU project.</EXPLANATION>
		</CARD>
	</ROUND>
	<ROUND value='3'>
		<CARD id='1'>
			<CATEGORY>Boolean Arithmetic</CATEGORY>
			<QUESTION>11110000 XOR 00111100 results in?</QUESTION>
			<ANSWER>11001100</ANSWER>
			<ANSWER>11111100</ANSWER>
			<ANSWER>00110000</ANSWER>
			<ANSWER>00110011</ANSWER>
			<EXPLANATION>The XOR operation sets a value to true (1) only when 1 and only 1 of the operands is true.</EXPLANATION>
		</CARD>
		<CARD id='2'>
			<CATEGORY>Movies</CATEGORY>
			<QUESTION>The movie that takes place after the Firefly TV series was</QUESTION>
			<ANSWER>Serenity</ANSWER>
			<ANSWER>Serendipity</ANSWER>
			<ANSWER>Pitch Black</ANSWER>
			<ANSWER>Singularity</ANSWER>
			<EXPLANATION>Serenity was the name of the Firefly class space ship that the TV series revolved around.</EXPLANATION>
		</CARD>
		<CARD id='3'>
			<CATEGORY>Biology</CATEGORY>
			<QUESTION>Males have which sex chromosomes?</QUESTION>
			<ANSWER>XY</ANSWER>
			<ANSWER>XX</ANSWER>
			<ANSWER>YY</ANSWER>
			<ANSWER>XP</ANSWER>
			<EXPLANATION>As both parents contribute to the sex chromosome the X chromosome comes from the mother and the Y chromosome comes from the father.</EXPLANATION>
		</CARD>
		<CARD id='4'>
			<CATEGORY>Food</CATEGORY>
			<QUESTION>The scale used to determine how hot chili peppers are is?</QUESTION>
			<ANSWER>The Scoville Scale</ANSWER>
			<ANSWER>The Jalapeno Scale</ANSWER>
			<ANSWER>The Flay Scale</ANSWER>
			<ANSWER>The Capsaicin scale</ANSWER>
			<EXPLANATION>While capsaicin is what causes chili peppers to be hot, this is measured using the Scoville Scale.</EXPLANATION>
		</CARD>
		<CARD id='5'>
			<CATEGORY>Mythology</CATEGORY>
			<QUESTION>The king of the Greek gods is</QUESTION>
			<ANSWER>Zeus</ANSWER>
			<ANSWER>Artemis</ANSWER>
			<ANSWER>Odin</ANSWER>
			<ANSWER>Acheron</ANSWER>
			<EXPLANATION>Zeus is the king of the Greek gods.</EXPLANATION>
		</CARD>
		<CARD id='6'>
			<CATEGORY>Computers</CATEGORY>
			<QUESTION>At the heart of every computer is the CPU. What is a CPU?</QUESTION>
			<ANSWER>Central Processing Unit</ANSWER>
			<ANSWER>Computer Power Unit</ANSWER>
			<ANSWER>ChiP Unit</ANSWER>
			<ANSWER>Complete Processing Unit</ANSWER>
			<EXPLANATION>The Central Processing Unit is not always in the center of the motherboard but is central because it is what controls everything.</EXPLANATION>
		</CARD>
	</ROUND>
	<ROUND value='4'>
		<CARD id='1'>
			<CATEGORY>Astronomy</CATEGORY>
			<QUESTION>The largest planet in our solar system is?</QUESTION>
			<ANSWER>Jupiter</ANSWER>
			<ANSWER>Earth</ANSWER>
			<ANSWER>Saturn</ANSWER>
			<ANSWER>Uranus</ANSWER>
			<ANSWER>Neptune</ANSWER>
			<EXPLANATION>Jupiter, named after the Roman king of the gods, is the largest planet in our solar system.</EXPLANATION>
		</CARD>
		<CARD id='2'>
			<CATEGORY>Literature</CATEGORY>
			<QUESTION>The Author of Lord of the Rings is?</QUESTION>
			<ANSWER>JRR Tolkien</ANSWER>
			<ANSWER>Robert Jordan</ANSWER>
			<ANSWER>Arthur C. Clark</ANSWER>
			<ANSWER>William Shakespeare</ANSWER>
			<ANSWER>Terry Brooks</ANSWER>
			<EXPLANATION>While all the people on the list are writers, only JRR Tolkien is responsible for Lord of the Rings.</EXPLANATION>
		</CARD>
		<CARD id='3'>
			<CATEGORY>Physics</CATEGORY>
			<QUESTION>What are Black Holes?</QUESTION>
			<ANSWER>Stars so massive that they collapse on themselves and have such high gravity that not even light can escape</ANSWER>
			<ANSWER>Doors to other dimensions</ANSWER>
			<ANSWER>The results of a Nova</ANSWER>
			<ANSWER>Dark regions of the sky</ANSWER>
			<ANSWER>A large gas giant but not large enough to become a star</ANSWER>
			<EXPLANATION>Stars so massive that they collapse on themselves and have such high gravity that not even light can escape</EXPLANATION>
		</CARD>
		<CARD id='4'>
			<CATEGORY>Canada</CATEGORY>
			<QUESTION>How many provinces are there in Canada?</QUESTION>
			<ANSWER>Ten</ANSWER>
			<ANSWER>Nine</ANSWER>
			<ANSWER>Eleven</ANSWER>
			<ANSWER>Twelve</ANSWER>
			<ANSWER>Thirteen</ANSWER>
			<EXPLANATION>There are ten provinces and three territories.</EXPLANATION>
		</CARD>
		<CARD id='5'>
			<CATEGORY>Blazing Games</CATEGORY>
			<QUESTION>Who is the predominant content creator for Blazing Games?</QUESTION>
			<ANSWER>Billy D. Spelchan</ANSWER>
			<ANSWER>Richard Garriott</ANSWER>
			<ANSWER>John Carmack</ANSWER>
			<ANSWER>Richard Stallman</ANSWER>
			<ANSWER>Bill Gates</ANSWER>
			<EXPLANATION>After running a Game of the Month home page, Billy D. Spelchan started Blazing Games Inc. with two other people.</EXPLANATION>
		</CARD>
		<CARD id='6'>
			<CATEGORY>Computer Games</CATEGORY>
			<QUESTION>Who is the lead programmer at id Software creating Wolfenstein 3D, Doom, Quake, and Rage?</QUESTION>
			<ANSWER>John Carmack</ANSWER>
			<ANSWER>Billy D. Spelchan</ANSWER>
			<ANSWER>Richard Garriott</ANSWER>
			<ANSWER>John Romero</ANSWER>
			<ANSWER>Richard Stallman</ANSWER>
			<EXPLANATION>John Carmack has created all the id game engines.</EXPLANATION>
		</CARD>
	</ROUND>
</DDWE8>

// ***** VARIABLES ***********************************************************
		
		private var _mode:int;
		private var _title:TriviaBombTitle;
		private var _game:TriviaBombGame;
		private var _about:About;
		
// ***** CONSTRUCTOR *********************************************************

		public function TriviaBomb()
		{
			_mode = MODE_NONE;
			_title = new TriviaBombTitle(this);
			_game = new TriviaBombGame(this, PUZZLE);

			_about = new About(this);
			_about.setCaption("About Trivia Bomb");
			_about.addPage(PAGE1_TEXT);
			_about.addPage(PAGE2_TEXT);
			changeMode(MODE_TITLE);
			stage.addEventListener(Event.ENTER_FRAME, handleEnterFrame);
			stage.addEventListener(KeyboardEvent.KEY_UP, handleKeyUp);
			stop();
		}
		
// ***** Functions - mode handlers ******************************************		
		
		public function changeMode(n:int):void
		{
			// remove old mode
			switch(_mode) {
				case MODE_NONE:
					break;
				case MODE_GAME:
					removeChild(_game);
					break;
				case MODE_TITLE:
					removeChild(_title);
					break;
				case MODE_ABOUT:
					removeChild(_about);
					break;
			}
			
			// change to the new mode
			switch(n) {
				case MODE_NONE:
					break;
				case MODE_GAME:
					_game.startGame(_title.getPlayMode());
					addChildAt(_game, 0);
					break;
				case MODE_TITLE:
					addChildAt(_title, 0);
					break;
				case MODE_ABOUT:
					addChildAt(_about, 0);
					break;
			}
			
			_mode = n;
		}

		public function handleEnterFrame(evt:Event):void
		{
			if (_mode == MODE_GAME)
				_game.updateTime();
		}

		public function handleKeyUp(evt:KeyboardEvent):void
		{
			if (_mode != MODE_GAME)
				return;
			_game.handleKeypress(evt.keyCode);
/*
			switch (evt.keyCode) {
				case Keyboard.UP:
					_game.slideUp();
					break;
				case Keyboard.LEFT:
					_game.slideLeft();
					break;
				case Keyboard.RIGHT:
					_game.slideRight();
					break;
				case Keyboard.DOWN:
					_game.slideDown();
					break;
				
			}
*/
		}

	}
}
