/*
Dozen Days of 
Copyright (c) 2008 Blazing Games Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
package com.blazinggames.dozendays
{
	import flash.display.SimpleButton;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.text.*;

	public class PlayerSetup
	extends Sprite
	{
// ***** CONSTANTS **********************************************************

		private static const LABEL_NAME:String = "Player Name";
		private static const LABEL_HUMAN:String = "Human";
		private static const LABEL_COMPUTER:String = "Computer";
		private static const LABEL_NONE:String = "None";
		
		public static const DEFAULT_NAMES:Array = new Array(
			"Red Player", "Yellow Player", "Green Player", 
			"Cyan Player", "Blue Player", "Magenta Player");
		public static const PLAYER_COLORS:Array = new Array(
			0xFF0000, 0xFFFF00, 0x00FF00, 
			0x00FFFF, 0x0000FF, 0xFF00FF);
		public static const PLAYER_BACKGROUNDS:Array = new Array(
			0x500000, 0x505000, 0x005000, 
			0x005050, 0x000050, 0x500050);
		public static const START_TEXT:String = "Start the Game!";

		public static const PLAYER_HUMAN:int = 0;
		public static const PLAYER_COMPUTER:int = 1;
		public static const PLAYER_NONE:int = 2;

// ***** VARIABLES **********************************************************

		protected var _playerNames:Array;
		protected var _radioButtons:Array;

// ***** CONSTRUCTOR ********************************************************

		public function PlayerSetup()
		{
			var textFormat:TextFormat = new TextFormat(null, 20, 0xFFFFFF, null, null, null, null, null, TextFormatAlign.LEFT);

			_playerNames = new Array();
			_radioButtons = new Array();
			var tempTF:TextField;
			var tempRT:RadioToggle;
			tempTF = new TextField();
			tempTF.defaultTextFormat = textFormat;
			tempTF.x = 10;
			tempTF.y = 0;
			tempTF.width = 300;
			tempTF.height = 25;
			tempTF.text = LABEL_NAME;
			addChild(tempTF);
			tempTF = new TextField();
			tempTF.defaultTextFormat = textFormat;
			tempTF.x = 340;
			tempTF.y = 0;
			tempTF.width = 100;
			tempTF.height = 25;
			tempTF.text = LABEL_HUMAN;
			addChild(tempTF);
			tempTF = new TextField();
			tempTF.defaultTextFormat = textFormat;
			tempTF.x = 440;
			tempTF.y = 0;
			tempTF.width = 100;
			tempTF.height = 25;
			tempTF.text = LABEL_COMPUTER;
			addChild(tempTF);
			tempTF = new TextField();
			tempTF.defaultTextFormat = textFormat;
			tempTF.x = 540;
			tempTF.y = 0;
			tempTF.width = 100;
			tempTF.height = 25;
			tempTF.text = LABEL_NONE;
			addChild(tempTF);
			for (var cntr:int = 0; cntr < 6; ++cntr) {
				textFormat = new TextFormat(null, 20, PLAYER_COLORS[cntr], null, null, null, null, null, TextFormatAlign.LEFT);
				tempTF = new TextField();
				tempTF.defaultTextFormat = textFormat;
				tempTF.y = 30 * cntr + 25;
				tempTF.width = 450;
				tempTF.height = 25;
				addChild(tempTF);
				tempTF.type = TextFieldType.INPUT;
				tempTF.text = DEFAULT_NAMES[cntr];				
				_playerNames[cntr] = tempTF;
				
				tempRT = new RadioToggle(true, 25, PLAYER_COLORS[cntr], PLAYER_BACKGROUNDS[cntr], 3);
				tempRT.x = 370;
				tempRT.y = tempTF.y;
				tempRT.addEventListener(MouseEvent.MOUSE_UP, handleClick);
				_radioButtons[cntr*3] = tempRT;
				addChild(tempRT);
				
				tempRT = new RadioToggle(false, 25, PLAYER_COLORS[cntr], PLAYER_BACKGROUNDS[cntr], 3);
				tempRT.x = 470;
				tempRT.y = tempTF.y;
				tempRT.addEventListener(MouseEvent.MOUSE_UP, handleClick);
				_radioButtons[cntr*3+1] = tempRT;
				addChild(tempRT);

				tempRT = new RadioToggle(false, 25, PLAYER_COLORS[cntr], PLAYER_BACKGROUNDS[cntr], 3);
				tempRT.x = 570;
				tempRT.y = tempTF.y;
				tempRT.addEventListener(MouseEvent.MOUSE_UP, handleClick);
				_radioButtons[cntr*3+2] = tempRT;
				addChild(tempRT);
			}

			//addEventListener(MouseEvent.MOUSE_UP, handleClick);
		}
		
// ***** Functions - Event Handlers *****************************************

		public function handleClick(evt:MouseEvent):void
		{
			var id:int = -1;
			for (var cntr:int = 0; cntr < _radioButtons.length; ++cntr)
				if (evt.target == _radioButtons[cntr])
					id = cntr;
			var group:int = Math.floor(id / 3)
			var member:int = id % 3;
			if (group >= 0) {
				_radioButtons[group * 3].setState(member==0);
				_radioButtons[group * 3 + 1].setState(member==1);
				_radioButtons[group * 3 + 2].setState(member==2);
			}
		}

// ***** Function - Player information ***************************************

		/* id = player number (0-5) */
		public function getPlayerType(id:uint):int
		{
			if (id > 5) return 0;
			
			if (_radioButtons[id * 3].getState())
				return PLAYER_HUMAN;
			else if (_radioButtons[id * 3 + 1].getState())
				return PLAYER_COMPUTER;
			else
				return PLAYER_NONE;
		}
		
		public function getPlayerName(id:uint):String
		{
			if (id > 5) return "unknown";
			return (_playerNames[id].text);
		}
	}
}
