/*
Dozen Days of 
Copyright (c) 2008 Blazing Games Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
package com.blazinggames.dozendays
{
	import flash.display.Shape;
	import flash.display.SimpleButton;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import flash.text.TextFormatAlign;

	public class TextButton
	extends SimpleButton
	{
// ***** CONSTANTS **********************************************************

		public static const DEFAULT_WIDTH:int = 320;
		public static const DEFAULT_HEIGHT:int = 40;
		public static const DEFAULT_FORMAT:TextFormat = new TextFormat(null, 24, null, null, null, null, null, null, TextFormatAlign.CENTER);

// ***** VARIABLES **********************************************************

		protected var _label:String;
		protected var tfUp:TextField;
		protected var tfDown:TextField;
		protected var tfOver:TextField;
		protected var hitbox:Shape;
		
// ***** CONSTRUCTOR ********************************************************

		public function TextButton(s:String, 
				w:int = DEFAULT_WIDTH, 
				h:int = DEFAULT_HEIGHT, 
				format:TextFormat = null)
		{
			if (format == null)
				format = DEFAULT_FORMAT;
			_label = s;
			tfUp = new TextField();
			tfUp.width = w;
			tfUp.height = h;
			tfUp.defaultTextFormat = format;
			tfUp.text = s;
			tfUp.textColor = 0xFFFFFF;
			tfUp.background = true;
			tfUp.backgroundColor = 0x000080;
			upState = tfUp;
			
			tfOver = new TextField();
			tfOver.width = w;
			tfOver.height = h;
			tfOver.defaultTextFormat = format;
			tfOver.text = s;
			tfOver.textColor = 0xFF00FF;
			tfOver.background = true;
			tfOver.backgroundColor = 0x0000CC;
			overState = tfOver;
			
			tfDown = new TextField();
			tfDown.width = w;
			tfDown.height = h;
			tfDown.defaultTextFormat = format;
			tfDown.text = s;
			tfDown.textColor = 0xFF0000;
			tfDown.background = true;
			tfDown.backgroundColor = 0x0000FF;
			downState = tfDown;
			
			hitbox = new Shape();
            hitbox.graphics.beginFill(0xFFFFFF);
            hitbox.graphics.drawRect(0, 0, w, h);
            hitbox.graphics.endFill();
			hitTestState = hitbox;
		}
// ***** Getting and setting *****

		public function getLabel():String
		{
			return _label;
		}
		
		public function setLabel(s:String):void
		{
			_label = s;
			tfUp.text = s;
			tfOver.text = s;
			tfDown.text = s;
		}
		
	}
}
