/*
Dozen Days of Words episode 2: Alphabet Points
Copyright (c) 2009 Blazing Games Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
package  com.blazinggames.dozendays {
	import flash.display.Sprite;
	import flash.events.*;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import flash.text.TextFormatAlign;

	public class YesNoDialog extends Sprite {

/***** CONSTANTS *****/

		public static const YESNO_YES_EVENT:String = "YesNo_Yes";
		public static const YESNO_NO_EVENT:String = "YesNo_No";

		private static const CAPTION_TEXT:String = "Message";
		private static const MESSAGE_TEXT:String = "Place message here!";
		private static const YES_TEXT:String = "Yes";
		private static const NO_TEXT:String = "No";


/***** VARIABLES *****/

		protected var _yesButton:TextButton;
		protected var _noButton:TextButton;
		protected var _captionText:TextField;
		protected var _messageText:TextField;
		protected var _statusText:TextField;

/***** CONSTRUCTOR *****/

		public function YesNoDialog(
				theCaption:String = CAPTION_TEXT,
				theMessage:String = MESSAGE_TEXT,
				yesText:String = YES_TEXT,
				noText:String = NO_TEXT,
				dialogWidth:int = 320, 
				dialogHeight:int = 120,
				dialogColor:uint = 0xFFFF00,
				dialogBackground:uint = 0x008000
		) {

			var textFormat:TextFormat = new TextFormat(null, 24, dialogColor, null, null, null, null, null, TextFormatAlign.CENTER);
			_captionText = new TextField();
			_captionText.width = dialogWidth;
			_captionText.height = dialogHeight;
			_captionText.defaultTextFormat = textFormat;
			_captionText.text = theCaption
			_captionText.background = true;
			_captionText.border = true;
			_captionText.borderColor = dialogColor;
			_captionText.backgroundColor = dialogBackground;
			addChild(_captionText);

			textFormat = new TextFormat(null, 16, 0xFFFF00, null, null, null, null, null, TextFormatAlign.CENTER);
			_messageText = new TextField();
			_messageText.x = 5;
			_messageText.y = 30;
			_messageText.width = dialogWidth - 10;
			_messageText.height = dialogHeight - 80;
			_messageText.defaultTextFormat = textFormat;
			_messageText.multiline = true;
			_messageText.wordWrap = true;
			_messageText.text = theMessage;
			addChild(_messageText);
			
			var buttonWidth:int = dialogWidth / 2 - 10;
			_yesButton = new TextButton(YES_TEXT, buttonWidth, 40);
			_yesButton.x = 5;
			_yesButton.y = dialogHeight - 45;
			addChild(_yesButton);
			_yesButton.addEventListener(MouseEvent.MOUSE_UP, handleYes);

			_noButton = new TextButton(NO_TEXT, buttonWidth, 40);
			_noButton.x = 15 + buttonWidth;
			_noButton.y = dialogHeight - 45;
			addChild(_noButton);
			_noButton.addEventListener(MouseEvent.MOUSE_UP, handleNo);

		}

/***** Functions - Getting and Setting *****/

		public function setCaption(newCaption:String = CAPTION_TEXT):void
		{
			_captionText.text = newCaption;
		}
		
		public function setMessage(newMessage:String = MESSAGE_TEXT):void
		{
			_messageText.text = newMessage;
		}

		public function setYesNo(
				yesText:String = YES_TEXT,
				noText:String = NO_TEXT
		):void {
			_yesButton.setLabel(yesText);
			_noButton.setLabel(noText);
		}

/***** Functions - Event handlers *****/

		private function handleYes(evt:Event):void
		{
			var evnt:Event = new Event(YESNO_YES_EVENT);
			dispatchEvent(evnt);
		}

		private function handleNo(evt:Event):void
		{
			var evnt:Event = new Event(YESNO_NO_EVENT);
			dispatchEvent(evnt);
		}

	}
}
