/*
Dozen Days of Words episode 8: Trivia Bomb
Copyright (c) 2009 Blazing Games Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
package com.blazinggames.dozendays.words.bomb
{
	import flash.display.GradientType;
	import flash.display.Sprite;
	import flash.geom.Matrix;

	public class Bomb
	extends Sprite
	{
// ***** CONSTANTS **********************************************************

		private var BOMB_COLORS:Array = new Array(0xFFFFFF, 0x404050, 0x101018);
		private var BOMBSTEM_COLORS:Array = new Array(0x505060, 0x404050, 0x101018);
		private var BOMB_ALPHAS:Array = new Array(1,1,1);
		private var BOMB_RATIOS:Array = new Array(0,24,255);

// ***** VARIABLES **********************************************************


// ***** CONSTRUCTOR ********************************************************

		public function Bomb()
		{
			render();
		}

// ***** FUNCTIONS - Rendering *****

		public function render():void
		{
			var m:Matrix = new Matrix();
			m.createGradientBox(256,256,0,0,0);
			graphics.clear();
//			graphics.lineStyle(_thick, _colour);
			//graphics.beginFill(0xFF00FF);
			graphics.beginGradientFill(GradientType.LINEAR, BOMB_COLORS, BOMB_ALPHAS, BOMB_RATIOS, m, "pad", "rgb", -0.25);
			graphics.drawRect(100,8,56,64);
            graphics.endFill();
			graphics.beginGradientFill(GradientType.RADIAL, BOMB_COLORS, BOMB_ALPHAS, BOMB_RATIOS, m, "pad", "rgb", -0.25);
			graphics.drawEllipse(100,0,56,16);
            graphics.endFill();
			graphics.beginGradientFill(GradientType.RADIAL, BOMB_COLORS, BOMB_ALPHAS, BOMB_RATIOS, m, "pad", "rgb", -0.25);
//			graphics.drawRect(100,16,56,40);
//			graphics.drawEllipse(100,0,56,32);
			graphics.drawEllipse(0,40,256,216);
//            graphics.drawEllipse(0, 0, 256, 256);
            graphics.endFill();
		}
	}
}
