/*
Dozen Days of Words episode 8: Trivia Bomb
Copyright (c) 2009 Blazing Games Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
package com.blazinggames.dozendays.words.bomb
{
	import flash.display.Sprite;
	import flash.events.MouseEvent;

	public class Spark
	extends Sprite
	{
// ***** CONSTANTS **********************************************************
// ***** VARIABLES **********************************************************

		protected var _theSize:int; 
		protected var _colour:uint; 
		protected var _spokes:uint; 
		protected var _thick:int;

// ***** CONSTRUCTOR ********************************************************

		public function Spark(
					theSize:int = 30, 
					colour:uint = 0xFFFFC0,
					spokes:int = 30,
					thick:int = 3) 
		{
			_theSize = theSize; 
			_colour = colour; 
			_spokes = spokes; 
			_thick = thick;
			
			render();
		}
		

// ***** Functions - Rendering **********************************************

		private function render():void
		{
			graphics.clear();
			graphics.lineStyle(_thick, _colour);
			var radsPerSpoke:Number = 2 * Math.PI / _spokes;
			var ang:Number = 0;
			for(var cntr:int = 0; cntr < _spokes; ++cntr) 
			{
				graphics.beginFill(_colour);
				graphics.moveTo(0, 0);
				graphics.lineTo(_theSize*Math.sin(ang),_theSize*Math.cos(ang));
				graphics.endFill();
				ang += radsPerSpoke;
			}
		}
	}
}
