/*
Dozen Days of Words episode 8: Trivia Bomb
Copyright (c) 2009 Blazing Games Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
package com.blazinggames.dozendays.words.bomb
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Rectangle;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import flash.text.TextFormatAlign;
	import flash.utils.getTimer;
	import flash.ui.Keyboard;

	import com.blazinggames.dozendays.*;
	import com.blazinggames.dozendays.words.*;

	public class TriviaBombGame
	extends Sprite
	{
// ***** CONSTANTS **********************************************************

		public static const BACKGROUND_COLOR:uint = 0x000050;
		public static const TILE_COLOR:uint = 0xC0C050;
		public static const BORDER_COLOR:uint = 0x000030;
		public static const LETTER_COLOR:uint = 0x200020;
		public static const TILE_COLOR_DIM:uint = 0xC000C0;
		public static const LETTER_COLOR_DIM:uint = 0x500050;
		public static const HIGHLIGHT_COLOR:uint = 0xFF0050;
		public static const WORD_COLOR:uint = 0x00C000;

		// Card category layout
		private static const CAT_WIDTH:int = 125;
		private static const CAT_HEIGHT:int = 100;
		private static const CAT_GAP:int = 10;
		private static const CAT_START_X:int = 160;
		private static const CAT_START_Y:int = 50;
		private static const CARD_BOUNDS:Rectangle = new Rectangle(70,40,500,400);

		// Bomb part layout
		private static const BOMB_LOCATION:Rectangle = new Rectangle(0,480-256,256,256);
		private static const LEFT_FUSE_LOCATION:Rectangle = new Rectangle(120,16,16, 480-256-8);
		private static const TOP_FUSE_LOCATION:Rectangle = new Rectangle(136,16,640-136-32, 16);
		private static const RIGHT_FUSE_LOCATION:Rectangle = new Rectangle(640-32,16,16, 400);
		private static const TIME_IN_ROUND:int = 60000;

		// Game States
		private static const GAME_STARTING:int = 0;
		private static const GAME_PLAYING:int = 1;
		private static const GAME_WON:int = 2;
		private static const GAME_LOST:int = 3;

// ***** VARIABLES **********************************************************

		protected var _trivia:TriviaBomb;
		protected var _doneButton:TextButton;
		protected var _tiles:Array;
		protected var _backdrop:TextField;

		protected var _currentLevel:int;
		protected var _score:int;
		protected var _bomb:Bomb;
		protected var _fuse:Array;
		protected var _roundData:Array;
		protected var _spark:Spark;
		protected var _explosion:Spark;

		// game play
		protected var _selectedCard:TriviaCard;
		protected var _selectedOrigin:Rectangle;
		protected var _correctCount:int;
		protected var _currentRound:int;
		protected var _fuseLength:int;
		protected var _startTime:int;
		protected var _gameState:int;
		
// ***** CONSTRUCTOR ********************************************************

		public function TriviaBombGame(trivia:TriviaBomb, puzzle:XML)
		{
			var cntrRow:int, cntrCol:int, rowLength:int, tileX:int, tileY:int;
			_trivia = trivia;

			_backdrop = new TextField();
			_backdrop.multiline = true;
			_backdrop.width = 640;
			_backdrop.height = 480;
			_backdrop.textColor = 0xC000C0;
			_backdrop.background = true;
			_backdrop.backgroundColor = BACKGROUND_COLOR;
			addChild(_backdrop);
			
			_bomb = new Bomb();
			_bomb.y = 480-256;
			addChild(_bomb);
			_fuse = new Array(3);
			_fuse[0] = new Fuse(LEFT_FUSE_LOCATION.width, LEFT_FUSE_LOCATION.height);
			_fuse[0].x = LEFT_FUSE_LOCATION.x;
			_fuse[0].y = LEFT_FUSE_LOCATION.y;
			addChild(_fuse[0]);
			_fuse[1] = new Fuse(TOP_FUSE_LOCATION.width, TOP_FUSE_LOCATION.height);
			_fuse[1].x = TOP_FUSE_LOCATION.x;
			_fuse[1].y = TOP_FUSE_LOCATION.y;
			addChild(_fuse[1]);
			_fuse[2] = new Fuse(RIGHT_FUSE_LOCATION.width, RIGHT_FUSE_LOCATION.height);
			_fuse[2].x = RIGHT_FUSE_LOCATION.x;
			_fuse[2].y = RIGHT_FUSE_LOCATION.y;
			addChild(_fuse[2]);
			_spark = new Spark();
			_spark.x = _fuse[2].x;
			_spark.y = _fuse[2].y;
			addChild(_spark);
			_fuseLength = _fuse[0].height + _fuse[1].width + _fuse[2].height;
			
			_tiles = new Array();
			var indx:int = 0;
			for (cntrRow = 0; cntrRow < 2; ++cntrRow) {
				tileX = CAT_START_X;
				tileY = CAT_START_Y + cntrRow * (CAT_HEIGHT + CAT_GAP);
				for (cntrCol = 0; cntrCol < 3; ++cntrCol) {
					_tiles[indx] = new TriviaCard("Trivia Bomb", "Question", new Array("Answer"), "explanation");
					_tiles[indx].x = tileX;
					_tiles[indx].y = tileY;
					_tiles[indx].width = CAT_WIDTH;
					_tiles[indx].height = CAT_HEIGHT;
//					_tiles[indx].setColors(LETTER_COLOR, TILE_COLOR);
//					_tiles[indx].setBorder(true, BORDER_COLOR);
					_tiles[indx].addEventListener(TriviaCard.CARD_SELECTED_EVENT, handleCardSelection);
					addChild(_tiles[indx]);

					tileX += CAT_WIDTH;
					tileX += CAT_GAP;
					++indx;
				}
				
			}
			
			_selectedCard = null;
			_selectedOrigin = new Rectangle();

			_roundData = new Array(4);
			for (cntrRow = 0; cntrRow < 4; ++cntrRow)
				_roundData[cntrRow] = puzzle.ROUND[cntrRow];
/*		
			var wordData:XML
			for each (wordData in puzzle.HORIZONTAL)
				addHorizontalWord(wordData.@x, wordData.@y, wordData.@word, wordData);
			for each (wordData in puzzle.VERTICAL)
				addVerticalWord(wordData.@x, wordData.@y, wordData.@word, wordData);
*/
			_explosion = new Spark(640, 0xFFC050, 90, 7);
			_explosion.x = BOMB_LOCATION.x + BOMB_LOCATION.width / 2;
			_explosion.y = BOMB_LOCATION.y + BOMB_LOCATION.height / 2;
			_explosion.visible = false;
			addChild(_explosion);

			_doneButton = new TextButton("Exit", 320, 50);
			_doneButton.x = 280;
			_doneButton.y = 330;
			addChild(_doneButton);
			_doneButton.addEventListener(MouseEvent.MOUSE_UP, handleExit);

		}

// ***** Functions - Puzzle Handling ****************************************

		public function startGame(playmode:int = 3):void
		{
			_score = 0;
			startRound(0);
		}

		public function startRound(n:int):void
		{
			for (var cntr:int = 0; cntr < 6; ++cntr) {
				_tiles[cntr].removeEventListener(TriviaCard.CARD_SELECTED_EVENT, handleCardSelection);
			}
			_correctCount = 0;
			_currentRound = n;
			if (_currentRound == 4) {
				_gameState = GAME_WON;
				_doneButton.setLabel("You won. Score " + (_score));
			} else {
				_gameState = GAME_STARTING;
				_doneButton.setLabel("Round " + (n+1));
			}
			_doneButton.visible = true;
			_explosion.visible = false;
		}

// ***** Functions - Event Handling *****

		private function handleExit(evt:Event):void
		{
			if (_gameState >= GAME_WON) {
				_trivia.changeMode(TriviaBomb.MODE_TITLE);
				return;
			}
			for (var cntr:int = 0; cntr < 6; ++cntr) {
				_tiles[cntr].setCardData(_roundData[_currentRound].CARD[cntr]);
				_tiles[cntr].addEventListener(TriviaCard.CARD_SELECTED_EVENT, handleCardSelection);
				_tiles[cntr].setCardState(TriviaCard.STATE_CATEGORY);				
			}
			_gameState = GAME_PLAYING;
			_doneButton.visible = false;
			_startTime = getTimer();			
		}

		private function handleCardSelection(evt:Event):void
		{
			for (var cntr:int = 0; cntr < _tiles.length; ++cntr)
				_tiles[cntr].visible = false;
			_selectedCard = TriviaCard(evt.target);
			_selectedOrigin.x = _selectedCard.x;
			_selectedOrigin.y = _selectedCard.y;
			_selectedOrigin.width = _selectedCard.width;
			_selectedOrigin.height = _selectedCard.height;

			_selectedCard.x = CARD_BOUNDS.x;
			_selectedCard.y = CARD_BOUNDS.y;
			_selectedCard.width = CARD_BOUNDS.width;
			_selectedCard.height = CARD_BOUNDS.height;
			_selectedCard.visible = true;
			_selectedCard.setCardState(TriviaCard.STATE_QUESTION);
			_selectedCard.removeEventListener(TriviaCard.CARD_SELECTED_EVENT, handleCardSelection);
			_selectedCard.addEventListener(TriviaCard.ANSWER_SELECTED_EVENT, handleAnswerSelection);
		}

		private function resetSelectedCard():void
		{
			for (var cntr:int = 0; cntr < _tiles.length; ++cntr)
				_tiles[cntr].visible = true;
			if (_selectedCard == null) return;
			_selectedCard.x = _selectedOrigin.x;
			_selectedCard.y = _selectedOrigin.y;
			_selectedCard.width = _selectedOrigin.width;
			_selectedCard.height = _selectedOrigin.height;
			_selectedCard.setCardState(TriviaCard.STATE_EXPLANATION);
//			_selectedCard.addEventListener(TriviaCard.CARD_SELECTED_EVENT, handleCardSelection);
			_selectedCard.removeEventListener(TriviaCard.ANSWER_SELECTED_EVENT, handleAnswerSelection);
			_selectedCard = null;
		}

		private function handleAnswerSelection(evt:Event):void
		{
			_selectedCard = TriviaCard(evt.target);
			if (_selectedCard.isCorrect())
				++_correctCount;
			resetSelectedCard();
			if (_correctCount >= 3) {
				_score += (TIME_IN_ROUND - (getTimer() - _startTime));
				startRound(_currentRound + 1);
			}
		}

		public function updateTime():void
		{
			if (_gameState != GAME_PLAYING) return;
			var curTime:int = getTimer() - _startTime;
			var pos:Number = _fuseLength - (_fuseLength / TIME_IN_ROUND * curTime);
			if (pos < 0) {
				_gameState = GAME_LOST;
				_explosion.visible = true;
				_doneButton.setLabel("You have Lost");
				_doneButton.visible = true;
				resetSelectedCard();
				return;
			}
			if (pos > _fuse[0].height) {
				pos -= _fuse[0].height;
				if (pos > _fuse[1].width) {
					pos -= _fuse[1].width;
					_spark.x = _fuse[2].x + 5;
					_spark.y = _fuse[2].y + pos;
				} else {
				_spark.y = _fuse[1].y + 5;
				_spark.x = _fuse[1].x + pos;
				}
			} else {
				_spark.x = _fuse[0].x + 5;
				_spark.y = _fuse[0].y + _fuse[0].height - pos;
			}
		}
		
// ***** Functions - game handling *******************************************

		public function handleKeypress(keycode:uint):void
		{
/*
			if ( (keycode >= 65) && (keycode <= 90) ) {
				_tiles[_cursorIndex].setLetter(String.fromCharCode(keycode));
				if (_tiles[_cursorIndex].getHorizontalClue() != null)
					keycode = Keyboard.RIGHT;
				else
					keycode = Keyboard.DOWN;
			}
			var cursorX:int = _cursorIndex % _boardWidth;
			var cursorY:int = _cursorIndex / _boardWidth;
			switch (keycode) {
				case Keyboard.UP:
					--cursorY;
					if (cursorY < 0)
						cursorY = _boardHeight - 1;
					break;
				case Keyboard.LEFT:
					--cursorX;
					if (cursorX < 0)
						cursorX = _boardWidth - 1;
					break;
				case Keyboard.RIGHT:
					++cursorX;
					if (cursorX >= _boardWidth)
						cursorX = 0;
					break;
				case Keyboard.DOWN:
					++cursorY;
					if (cursorY >= _boardHeight)
						cursorY = 0;
					break;
			}
			setCursorLocation(cursorY * _boardWidth + cursorX);
*/
		}
	}
}
