/*
Dozen Days of Words episode 8: Trivia Bomb
Copyright (c) 2009 Blazing Games Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
package com.blazinggames.dozendays.words.bomb
{
	import flash.display.SimpleButton;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import flash.text.TextFormatAlign;

	import com.blazinggames.dozendays.TextButton;
	import com.blazinggames.dozendays.words.LetterTile;

	public class TriviaBombTitle
	extends Sprite
	{
// ***** CONSTANTS **********************************************************

		public static const START_EASY_TEXT:String = "Play the Game!";
		public static const START_NORMAL_TEXT:String = "Play Normal Game!";
		public static const START_HARD_TEXT:String = "Play Hard Game!";
		public static const ABOUT_TEXT:String = "About the Game!";
		private static const COPYRIGHT_TXT:String = 
"Developed by Billy D. Spelchan. Copyright \xa9 2009 Blazing Games Inc.";

		public static const PLAY_EASY:int = 0;
		public static const PLAY_NORMAL:int = 1;
		public static const PLAY_HARD:int = 2;

		private static const TILE_SIZE:int = 90;
		private static const TILE_COLOR:uint = 0x000050;
		private static const BORDER_COLOR:uint = 0x200020;
		private static const LETTER_COLOR:uint = 0x00C0C0;
		
// ***** VARIABLES **********************************************************

		protected var _trivia:TriviaBomb;
		protected var _easyButton:TextButton;
		protected var _normalButton:TextButton;
		protected var _hardButton:TextButton;
		protected var _aboutButton:TextButton;
		protected var _puzzleName:TextField;

		public var _playmode:int;

// ***** CONSTRUCTOR ********************************************************

		public function TriviaBombTitle(trivia:TriviaBomb)
		{
			_playmode = PLAY_NORMAL;
			_trivia = trivia;

			var bomb:Bomb = new Bomb();
			bomb.width = 640;
			bomb.height = 640;
			addChild(bomb);

			var titleFormat:TextFormat = new TextFormat(null, 90, 0xFFFF00, null, null, null, null, null, TextFormatAlign.CENTER);
			var title:TextField = new TextField();
			title.x = 0;
			title.y = 200;
			title.width = 640;
			title.height = 280;
			title.multiline = true;
			title.wordWrap = true;
			title.defaultTextFormat = titleFormat;
			title.text = "Trivia Bomb";
			addChild(title);
/*			
			makeLetter(180,0,"C");
			makeLetter(180,90,"R");
			makeLetter(180,180,"O");
			makeLetter(180,270,"S");
			makeLetter(180,360,"S");
			makeLetter(90,180,"W");
			makeLetter(270,180,"R");
			makeLetter(360,180,"D");
*/			
			var puzzleFormat:TextFormat = new TextFormat(null, 28, 0xFFFF00, null, null, null, null, null, TextFormatAlign.CENTER);
			_puzzleName = new TextField();
			_puzzleName.x = 300;
			_puzzleName.y = 290;
			_puzzleName.width = 320;
			_puzzleName.height = 30;
			_puzzleName.defaultTextFormat = puzzleFormat;
			_puzzleName.text = "Version 1.0.0";
			addChild(_puzzleName);

			_easyButton = new TextButton(START_EASY_TEXT, 300, 40);
			_easyButton.x = 160;
			_easyButton.y = 340;
			addChild(_easyButton);
			_easyButton.addEventListener(MouseEvent.MOUSE_UP, handleStart);

			_aboutButton = new TextButton(ABOUT_TEXT, 300, 40);
			_aboutButton.x = 160;
			_aboutButton.y = 400;
			addChild(_aboutButton);
			_aboutButton.addEventListener(MouseEvent.MOUSE_UP, handleAbout);
			
			var crFormat:TextFormat = new TextFormat(null, 15, 0xFFFFFF, null, null, null, null, null, TextFormatAlign.CENTER);
			var copyright:TextField = new TextField();
			copyright.x = 0;
			copyright.y = 460;
			copyright.width = 640;
			copyright.height = 20;
			copyright.defaultTextFormat = crFormat;
			copyright.wordWrap = true;
			copyright.text = COPYRIGHT_TXT;
			addChild(copyright);
		}

		public function getPlayMode():int
		{
			return _playmode;
		}
		
		private function makeLetter(tx:int, ty:int, s:String):void
		{
			var tile:LetterTile = new LetterTile(TILE_SIZE,TILE_SIZE, s);
			tile.x = tx;
			tile.y = ty;
			tile.setColors(LETTER_COLOR, TILE_COLOR);
			tile.setBorder(true, BORDER_COLOR);
			addChild(tile);
		}

// ***** Functions - Event Handling *****************************************

		private function handleStart(evt:Event):void
		{
			if (evt.target == _normalButton)
				_playmode = PLAY_NORMAL;
			else if (evt.target == _easyButton)
				_playmode = PLAY_EASY;
			else
				_playmode = PLAY_HARD;
				
			_trivia.changeMode(TriviaBomb.MODE_GAME);
		}

		private function handleAbout(evt:Event):void
		{
			_trivia.changeMode(TriviaBomb.MODE_ABOUT);
		}

	}
}
