/*
Dozen Days of Words episode 8: Trivia Bomb
Copyright (c) 2009 Blazing Games Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
package com.blazinggames.dozendays.words.bomb
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Rectangle;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import flash.text.TextFormatAlign;

	import com.blazinggames.dozendays.RadioToggle;
	
	public class TriviaCard
	extends Sprite
	{
// ***** CONSTANTS **********************************************************

		// Events
		public static const CARD_SELECTED_EVENT:String = "CardSelected";
		public static const ANSWER_SELECTED_EVENT:String = "CardSelected";

		public static const CORRECT_TEXT:String = "Correct!";
		public static const INCORRECT_TEXT:String = "Incorrect!";
		
		// Game States
		public static const STATE_CATEGORY:int = 0;
		public static const STATE_QUESTION:int = 1;
		public static const STATE_EXPLANATION:int = 2;
		
		// Colors
		public static const BACK_COLOR:uint = 0xC0C0FF;
		public static const CATEGORY_COLOR:uint = 0x000020;
		public static const QUESTION_COLOR:uint = 0x500050;
		public static const ANSWER_COLOR:uint = 0x000020;
		public static const SELECTED_COLOR:uint = 0x008000;
		public static const CORRECT_COLOR:uint = 0x00C000;
		public static const INCORRECT_COLOR:uint = 0xC00000;
		public static const EXPLANATION_COLOR:uint = 0x800080;

		// Text formats
		public static const CATEGORY_FORMAT:TextFormat = new TextFormat(null, 90, CATEGORY_COLOR, null, null, null, null, null, TextFormatAlign.CENTER);
		public static const QUESTION_FORMAT:TextFormat = new TextFormat(null, 25, QUESTION_COLOR, null, null, null, null, null, TextFormatAlign.LEFT);
		public static const ANSWER_FORMAT:TextFormat = new TextFormat(null, 20, ANSWER_COLOR, null, null, null, null, null, TextFormatAlign.LEFT);
		public static const CORRECT_FORMAT:TextFormat = new TextFormat(null, 90, CORRECT_COLOR, null, null, null, null, null, TextFormatAlign.CENTER);
		public static const INCORRECT_FORMAT:TextFormat = new TextFormat(null, 90, INCORRECT_COLOR, null, null, null, null, null, TextFormatAlign.CENTER);
		public static const EXPLANATION_FORMAT:TextFormat = new TextFormat(null, 40, EXPLANATION_COLOR, null, null, null, null, null, TextFormatAlign.CENTER);

		// layout
		public static const CARD_LAYOUT:Rectangle = new Rectangle(0,0,500,400);
		public static const CATEGORY_LAYOUT:Rectangle = new Rectangle(0,100,500,300);
		public static const QUESTION_LAYOUT:Rectangle = new Rectangle(10,10,480,100);
		public static const ANSWERRADIO_LAYOUT:Rectangle = new Rectangle(10,125,50,50);
		public static const ANSWER_LAYOUT:Rectangle = new Rectangle(100,125,390,50);
		public static const CORRECT_LAYOUT:Rectangle = new Rectangle(0,0,500,100);
		public static const EXPLANATION_LAYOUT:Rectangle = new Rectangle(0,100,500,300);
		
		
// ***** VARIABLES **********************************************************

		// trivia information
		public var _category:String;
		public var _question:String;
		public var _answers:Array;
		public var _explanation:String;

		// "visible" components
		protected var _card:TextField;
		protected var _categoryText:TextField;
		protected var _questionText:TextField;
		protected var _answersRadio:Array;
		protected var _answersText:Array;
		protected var _explanationText:TextField;
		protected var _correctText:TextField;
		protected var _incorrectText:TextField;
		protected var _numAnswers:int;
		
		// gameplay management
		protected var _correctAnswer:int;
		protected var _selectedAnswer:int;
		protected var _gameState:int;

// ***** CONSTRUCTOR ********************************************************

		public function TriviaCard(category:String, question:String, 
				answers:Array, explanation:String)
		{
			//
			_category = category;
			_question = question;
			_answers = answers;
			_explanation = explanation;
			
			_card = createTextView(CARD_LAYOUT, ANSWER_FORMAT, " ", true);
			_card.background = true;
			_card.backgroundColor = BACK_COLOR;
			_categoryText = createTextView(CATEGORY_LAYOUT, CATEGORY_FORMAT, category, true);
			_questionText = createTextView(QUESTION_LAYOUT, QUESTION_FORMAT, question, true);
			_answersRadio = new Array(5);
			_answersText = new Array(5);
			var radRect:Rectangle = new Rectangle(ANSWERRADIO_LAYOUT.x, ANSWERRADIO_LAYOUT.y, ANSWERRADIO_LAYOUT.width, ANSWERRADIO_LAYOUT.height);
			var txtRect:Rectangle = new Rectangle(ANSWER_LAYOUT.x, ANSWER_LAYOUT.y, ANSWER_LAYOUT.width, ANSWER_LAYOUT.height);
			for (var cntr:int = 0; cntr < 5; ++cntr) {
				_answersRadio[cntr] = new RadioToggle(cntr==0,40,0,0xFFFFFF,5);
				_answersRadio[cntr].x = radRect.x;
				_answersRadio[cntr].y = radRect.y;
				_answersRadio[cntr].addEventListener(MouseEvent.MOUSE_UP, handleAnswerSelection);
				addChild(_answersRadio[cntr]);
				radRect.offset(0, ANSWERRADIO_LAYOUT.height);
				
				_answersText[cntr] = createTextView(txtRect, ANSWER_FORMAT, answers[0], true);
				_answersText[cntr].removeEventListener(MouseEvent.MOUSE_UP, handleCardSelection);
				_answersText[cntr].addEventListener(MouseEvent.MOUSE_UP, handleAnswerSelection);
				txtRect.offset(0, ANSWER_LAYOUT.height);
			}
			_explanationText = createTextView(EXPLANATION_LAYOUT, EXPLANATION_FORMAT, explanation, true);
			_correctText = createTextView(CORRECT_LAYOUT, CORRECT_FORMAT, CORRECT_TEXT, false);
			_incorrectText = createTextView(CORRECT_LAYOUT, INCORRECT_FORMAT, INCORRECT_TEXT, false);
			setCardState(STATE_CATEGORY);
		}

		private function createTextView(rect:Rectangle, 
				format:TextFormat, 
				s:String,
				ww:Boolean):TextField
		{
			var tf:TextField = new TextField();
			tf.x = rect.x;
			tf.y = rect.y;
			tf.width = rect.width;
			tf.height = rect.height;
			tf.defaultTextFormat = format;
			tf.multiline = true;
			tf.wordWrap = ww;
			tf.text = s;
			tf.addEventListener(MouseEvent.MOUSE_UP, handleCardSelection);
			addChild(tf);
			return tf;
		}

// ***** Functions - Event passing **************************************

		private function handleCardSelection(evt:Event):void
		{
			if (_gameState == STATE_QUESTION) return;
			var evnt:Event = new Event(CARD_SELECTED_EVENT);
			dispatchEvent(evnt);
		}

		private function handleAnswerSelection(evt:Event):void
		{
			var indx:int = -1;
			for (var cntr:int = 0; cntr < 5; ++cntr) {
				if (_answersRadio[cntr] == evt.target)
					indx = cntr;
				if (_answersText[cntr] == evt.target)
					indx = cntr;
			}
			_selectedAnswer = indx;
			var evnt:Event = new Event(ANSWER_SELECTED_EVENT);
			dispatchEvent(evnt);
		}

// ***** Functions - Getting and Setting**************************************

		public function setCardData(data:XML):void
		{
			var cntr:int;

			_categoryText.text = data.CATEGORY;
			_questionText.text = data.QUESTION;
			_numAnswers = data.ANSWER.length();
			for (cntr = 0; cntr < _numAnswers; ++cntr) {				
				_answersText[cntr].text = data.ANSWER[cntr];
			}
			_explanationText.text = data.EXPLANATION;
			
			var temp:String;
			var swap:int;
			_correctAnswer = 0;
			for (cntr = 0; cntr < _numAnswers; ++cntr) {
				swap = Math.floor(Math.random() * _numAnswers);
				temp = _answersText[cntr].text;				
				_answersText[cntr].text = _answersText[swap].text;
				_answersText[swap].text = temp;
				if (swap == _correctAnswer)
					_correctAnswer = cntr;
				else if (cntr == _correctAnswer)
					_correctAnswer = swap;
			}
			
		}

		public function setCardState(n:int):void
		{
			var cntr:int;
			
			_gameState = n;
			_categoryText.visible = false;
			_questionText.visible = false;
			for (cntr = 0; cntr < _answersText.length; ++cntr) {
				_answersText[cntr].visible = false;
				_answersRadio[cntr].visible = false;
			}
			_explanationText.visible = false;
			_correctText.visible = false;
			_incorrectText.visible = false;
			
			switch(n) {
			case STATE_CATEGORY:
				_categoryText.visible = true;
				break;
			case STATE_QUESTION:
				_questionText.visible = true;
				for (cntr = 0; cntr < _numAnswers; ++cntr) {
					_answersText[cntr].visible = true;
					_answersRadio[cntr].visible = true;
				}
				break;
			case STATE_EXPLANATION:
				_explanationText.visible = true;
				_correctText.visible = _correctAnswer == _selectedAnswer;
				_incorrectText.visible = _correctAnswer != _selectedAnswer;
				break;
			}
		}
		
		public function isCorrect():Boolean
		{
			return _correctAnswer == _selectedAnswer;
		}
	}
}

