/*
Dozen Days of Words episode 1: Scrambled Chain
Copyright (c) 2008-2009 Blazing Games Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
package
{
	import flash.display.MovieClip;
	import flash.events.*;
	import flash.text.TextField;

	import com.blazinggames.dozendays.*;
	import com.blazinggames.dozendays.words.*;
	import com.blazinggames.dozendays.words.scrambled.*;
	
	[SWF(width="640", height="480", backgroundColor="#000000")]
	
	public class Scrambled extends MovieClip implements IGameMode
	{
// ***** CONSTANTS ***********************************************************
		public static const PAGE1_TEXT:String = 
"This game was created for Blazing Games Inc. by Billy D. Spelchan "+
"(the person writing this).\n\n"+
"This game is part of the Dozen Days of Words series which is a collection of "+
"Games that are created in under 24 hours of working time that revolve around "+
"the creation of computer versions of word games. This episode is a version " +
"of Scrambled Chain, which is a game that extends upon the word scramble game "+
"by making the player unscramble 4 words at the same time. " +
"See the Development Journal for this game on BlazingGames.com for more " +
"details about how the game was created.";

		public static const PAGE2_TEXT:String = 
"This program is free software; you can redistribute it and/or modify "+
"it under the terms of the GNU General Public License as published by "+
"the Free Software Foundation; either version 2 of the License, or "+
"(at your option) any later version.\n\n"+
"This program is distributed in the hope that it will be useful, "+
"but WITHOUT ANY WARRANTY; without even the implied warranty of "+
"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the "+
"GNU General Public License for more details.\n\n"+
"You should have received a copy of the GNU General Public License "+
"along with this program; if not, write to the Free Software "+
"Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA";

		public static const MODE_NONE:int = 0;
		public static const MODE_TITLE:int = 1;
		public static const MODE_GAME:int = 2;
		public static const MODE_ABOUT:int = 3;

		public static const WORDDATA:XML =
<SCRAMBLED_CHAIN>
	<NAME>SIMPLE TEST</NAME>
	<AUTHOR>Billy D. Spelchan</AUTHOR>
	<PUZZLE>
		<NAME>Animals</NAME>
		<FOURWORD>WOLF</FOURWORD>
		<FOURWORD>LION</FOURWORD>
		<FOURWORD>BULL</FOURWORD>
		<FOURWORD>MOLE</FOURWORD>
		<FIVEWORD>TIGER</FIVEWORD>
		<FIVEWORD>HORSE</FIVEWORD>
		<FIVEWORD>SNAKE</FIVEWORD>
		<FIVEWORD>MOUSE</FIVEWORD>
		<FIVEWORD>EAGLE</FIVEWORD>
		<FIVEWORD>HUMAN</FIVEWORD>
		<SIXWORD>BABOON</SIXWORD>
		<SIXWORD>DONKEY</SIXWORD>
		<SIXWORD>MONKEY</SIXWORD>
		<SEVENWORD>BUFFALO</SEVENWORD>
		<SEVENWORD>BUZZARD</SEVENWORD>
		<SEVENWORD>CHICKEN</SEVENWORD>
		<HINT>Animals that exist in the real world.</HINT>
	</PUZZLE>
	<PUZZLE>
		<NAME>Food</NAME>
		<HINT>Some of my favorite foods.</HINT>
		<FOURWORD>FISH</FOURWORD>
		<FOURWORD>SODA</FOURWORD>
		<FOURWORD>CAKE</FOURWORD>
		<FOURWORD>MINT</FOURWORD>
		<FIVEWORD>PIZZA</FIVEWORD>
		<FIVEWORD>PASTA</FIVEWORD>
		<FIVEWORD>FRIES</FIVEWORD>
		<SIXWORD>BURGER</SIXWORD>
		<SIXWORD>NOODLE</SIXWORD>
		<SIXWORD>SHRIMP</SIXWORD>
		<SIXWORD>CHEESE</SIXWORD>
		<SEVENWORD>LASAGNA</SEVENWORD>
		<SEVENWORD>CHICKEN</SEVENWORD>
	</PUZZLE>
	<PUZZLE>
		<NAME>Game</NAME>
		<HINT>Words associated with games.</HINT>
		<FOURWORD>CARD</FOURWORD>
		<FOURWORD>DICE</FOURWORD>
		<FOURWORD>TILE</FOURWORD>
		<FOURWORD>WORD</FOURWORD>
		<FIVEWORD>BOARD</FIVEWORD>
		<FIVEWORD>TABLE</FIVEWORD>
		<FIVEWORD>LOGIC</FIVEWORD>
		<SIXWORD>ACTION</SIXWORD>
		<SIXWORD>ARCADE</SIXWORD>
		<SIXWORD>PUZZLE</SIXWORD>
		<SIXWORD>RACING</SIXWORD>
		<SIXWORD>TRIVIA</SIXWORD>
		<SEVENWORD>JUMPING</SEVENWORD>
		<SEVENWORD>FANTASY</SEVENWORD>
	</PUZZLE>
	<PUZZLE>
		<NAME>Mystical Beasts</NAME>
		<HINT>Creatures from myths and legends.</HINT>
		<FOURWORD>OGRE</FOURWORD>
		<FOURWORD>LICH</FOURWORD>
		<FOURWORD>YETI</FOURWORD>
		<FIVEWORD>PIXIE</FIVEWORD>
		<FIVEWORD>TROLL</FIVEWORD>
		<FIVEWORD>SLIME</FIVEWORD>
		<FIVEWORD>HYDRA</FIVEWORD>
		<FIVEWORD>MUMMY</FIVEWORD>
		<SIXWORD>DRAGON</SIXWORD>
		<SIXWORD>GOBLIN</SIXWORD>
		<SIXWORD>MEDUSA</SIXWORD>
		<SEVENWORD>PEGASUS</SEVENWORD>
		<SEVENWORD>UNICORN</SEVENWORD>
		<SEVENWORD>CHIMERA</SEVENWORD>
	</PUZZLE>
	<PUZZLE>
		<NAME>Numbers</NAME>
		<HINT>You know:3,4,5,20 except written.</HINT>
		<FOURWORD>FOUR</FOURWORD>
		<FOURWORD>FIVE</FOURWORD>
		<FOURWORD>NINE</FOURWORD>
		<FIVEWORD>THREE</FIVEWORD>
		<FIVEWORD>SEVEN</FIVEWORD>
		<FIVEWORD>EIGHT</FIVEWORD>
		<SIXWORD>ELEVEN</SIXWORD>
		<SIXWORD>TWELVE</SIXWORD>
		<SIXWORD>TWENTY</SIXWORD>
		<SEVENWORD>FIFTEEN</SEVENWORD>
		<SEVENWORD>SIXTEEN</SEVENWORD>
	</PUZZLE>
	<PUZZLE>
		<NAME>Programming</NAME>
		<HINT>There are many different programming languages.</HINT>
		<FOURWORD>PERL</FOURWORD>
		<FOURWORD>JAVA</FOURWORD>
		<FOURWORD>RUBY</FOURWORD>
		<FIVEWORD>BASIC</FIVEWORD>
		<FIVEWORD>COBAL</FIVEWORD>
		<FIVEWORD>FLASH</FIVEWORD>
		<SIXWORD>PROLOG</SIXWORD>
		<SIXWORD>PASCAL</SIXWORD>
		<SIXWORD>PYTHON</SIXWORD>
		<SEVENWORD>FORTRAN</SEVENWORD>
	</PUZZLE>
	<PUZZLE>
		<NAME>Shapes</NAME>
		<HINT>Common two and three dimensional shapes.</HINT>
		<FOURWORD>CUBE</FOURWORD>
		<FOURWORD>BALL</FOURWORD>
		<FOURWORD>OVAL</FOURWORD>
		<FOURWORD>KITE</FOURWORD>
		<FIVEWORD>PLAIN</FIVEWORD>
		<FIVEWORD>CURVE</FIVEWORD>
		<FIVEWORD>HELIX</FIVEWORD>
		<SIXWORD>SQUARE</SIXWORD>
		<SIXWORD>CIRCLE</SIXWORD>
		<SIXWORD>SHPERE</SIXWORD>
		<SEVENWORD>DIAMOND</SEVENWORD>
		<SEVENWORD>ELLIPSE</SEVENWORD>
		<SEVENWORD>HEXAGON</SEVENWORD>
		<SEVENWORD>PYRAMID</SEVENWORD>
		<SEVENWORD>RHOMBUS</SEVENWORD>
	</PUZZLE>
</SCRAMBLED_CHAIN>;

// ***** VARIABLES ***********************************************************
		
		private var _logDisplay:TextField;
		private var _mode:int;
		private var _title:ScrambledTitle;
		private var _game:ScrambledGame;
		private var _about:About;
		
// ***** CONSTRUCTOR *********************************************************

		public function Scrambled()
		{
			_mode = MODE_NONE;
			_title = new ScrambledTitle(this, WORDDATA);
			_game = new ScrambledGame(this);
			_game.setPuzzleData(WORDDATA);

			_about = new About(this);
			_about.setCaption("About Scrambled Chain");
			_about.addPage(PAGE1_TEXT);
			_about.addPage(PAGE2_TEXT);
			changeMode(MODE_TITLE);
			stop();
		}
		
// ***** Functions - mode handlers ******************************************		
		
		public function changeMode(n:int):void
		{
			// remove old mode
			switch(_mode) {
				case MODE_NONE:
					break;
				case MODE_GAME:
					removeChild(_game);
					break;
				case MODE_TITLE:
					removeChild(_title);
					break;
				case MODE_ABOUT:
					removeChild(_about);
					break;
			}
			
			// change to the new mode
			switch(n) {
				case MODE_NONE:
					break;
				case MODE_GAME:
					_game.startGame(_title.getSelectedPuzzle());
					addChildAt(_game, 0);
					break;
				case MODE_TITLE:
					addChildAt(_title, 0);
					break;
				case MODE_ABOUT:
					addChildAt(_about, 0);
					break;
			}
			
			_mode = n;
		}
	
	}
}
