/*
Dozen Days
Copyright (c) 2008 Blazing Games Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
package com.blazinggames.dozendays
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import flash.text.TextFormatAlign;

	import com.blazinggames.dozendays.TextButton;

	public class About
	extends Sprite
	{
// ***** CONSTANTS **********************************************************

// ***** VARIABLES **********************************************************

		protected var _game:IGameMode;
		protected var _prevButton:TextButton;
		protected var _nextButton:TextButton;		
		protected var _doneButton:TextButton;
		protected var _captionText:TextField;
		protected var _aboutText:TextField;
		protected var _pages:Array;
		protected var _page:int = 0;
		protected var _doneMode:int;

// ***** CONSTRUCTOR ********************************************************

		public function About(game:IGameMode, doneMode:int = 1)
		{
			_game = game;
			_doneMode = doneMode;
			_pages = new Array();
			var format:TextFormat = new TextFormat(null, 42, 0xFFFF00, null, null, null, null, null, TextFormatAlign.CENTER);
			var formatAbout:TextFormat = new TextFormat(null, 18, 0xCCCC00);
			_captionText = new TextField();
			_captionText.x = 0;
			_captionText.y = 0;
			_captionText.width = 640;
			_captionText.height = 70;
			_captionText.defaultTextFormat = format;
			_captionText.text = "About";
			addChild(_captionText);

			_aboutText = new TextField();
			_aboutText.x = 10;
			_aboutText.y = 70;
			_aboutText.width = 620;
			_aboutText.height = 300;
			_aboutText.wordWrap = true;
			_aboutText.defaultTextFormat = formatAbout;
			_aboutText.text = "No info";
			addChild(_aboutText);
			_prevButton = new TextButton("Previous", 200, 40);
			_prevButton.x = 10;
			_prevButton.y = 420;
			addChild(_prevButton);
			_prevButton.addEventListener(MouseEvent.MOUSE_UP, handlePrev);
			
			_doneButton = new TextButton("Done!", 200,40);
			_doneButton.x = 220;
			_doneButton.y = 420;
			addChild(_doneButton);
			_doneButton.addEventListener(MouseEvent.MOUSE_UP, handleDone);
			
			_nextButton = new TextButton("Next", 200, 40);
			_nextButton.x = 430;
			_nextButton.y = 420;
			addChild(_nextButton);
			_nextButton.addEventListener(MouseEvent.MOUSE_UP, handleNext);
		}

// ***** Functions - Event Handling *****************************************

		private function handlePrev(evt:Event):void
		{
			showPage(_page-1);
		}

		private function handleDone(evt:Event):void
		{
			_game.changeMode(_doneMode);
		}
		
		private function handleNext(evt:Event):void
		{
			showPage(_page+1);
		}

// ***** Functions - Page handling ******************************************

		public function setCaption(s:String):void
		{
			_captionText.text = s;
		}
		
		public function addPage(s:String):void
		{
			_pages.push(s);
			showPage(_page);
		}
		
		protected function showPage(page:int):void
		{
			_page = page;
			_prevButton.visible = true;
			_nextButton.visible = true;
			if (page >= (_pages.length - 1)) {
				_page = _pages.length - 1;
				_nextButton.visible = false;
			}
			if (page <= 0) {
				_page = 0;
				_prevButton.visible = false;
			} 
			_aboutText.text = _pages[_page];
		}

	}
}
