/*
Dozen Days of Dice episode 7: Hearts
Copyright (c) 2008 Blazing Games Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
package com.blazinggames.dozendays
{
	import flash.display.Sprite;
	import flash.events.MouseEvent;

	public class RadioToggle
	extends Sprite
	{
// ***** CONSTANTS **********************************************************
// ***** VARIABLES **********************************************************

		protected var _isSet:Boolean;
		protected var _theSize:int; 
		protected var _colour:uint; 
		protected var _bColor:uint; 
		protected var _thick:int;

// ***** CONSTRUCTOR ********************************************************

		public function RadioToggle(
					isSet:Boolean = false,
					theSize:int = 20, 
					colour:uint = 0, 
					bColor:uint = 0xFFFFFF, 
					thick:int = 3) 
		{
			_isSet = isSet;
			_theSize = theSize; 
			_colour = colour; 
			_bColor = bColor; 
			_thick = thick;
			
			render();
		}
		
// ***** Functions - Getting and Setting ************************************

		public function setState(b:Boolean):void
		{
			_isSet = b;
			render();
		}

		public function getState():Boolean
		{
			return _isSet;
		}

// ***** Functions - Rendering **********************************************

		private function render():void
		{
			graphics.clear();
			graphics.lineStyle(_thick, _colour);
			graphics.beginFill(_bColor);
            graphics.drawEllipse(0, 0, _theSize, _theSize);
            graphics.endFill();
			
			if (_isSet) {
				graphics.beginFill(_colour);
				graphics.lineStyle(NaN);
				graphics.drawEllipse(_thick, _thick, _theSize-_thick*2, _theSize-_thick*2);
				graphics.endFill();
			}
		}
	}
}
