/*
Dozen Days of 
Copyright (c) 2008 Blazing Games Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
package com.blazinggames.dozendays
{
	import flash.display.SimpleButton;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import flash.text.TextFormatAlign;

	import com.blazinggames.dozendays.*;

	public class Title
	extends Sprite
	{
// ***** CONSTANTS **********************************************************

		public static const START_TEXT:String = "Start the Game!";
		public static const ABOUT_TEXT:String = "About the Game!";
		private static const COPYRIGHT_TXT:String = 
"Developed by Billy D. Spelchan. Copyright \xa9 2008 Blazing Games Inc.";

// ***** VARIABLES **********************************************************

		protected var _game:IGameMode;
		protected var _startMode:int;
		protected var _aboutMode:int;
		protected var _startButton:TextButton;
		protected var _aboutButton:TextButton;

		public var _setup:PlayerSetup;

// ***** CONSTRUCTOR ********************************************************

		public function Title(game:IGameMode, 
				gameName:String, 
				subtitle:String = " ",
				startMode:int = 2,
				aboutMode:int = 3,
				startButtonName:String = START_TEXT,
				aboutButtonName:String = ABOUT_TEXT,
				copyrt:String = COPYRIGHT_TXT)
		{
			_game = game;
			var titleFormat:TextFormat = new TextFormat(null, 120, 0xFFFF00, null, null, null, null, null, TextFormatAlign.CENTER);
			var title:TextField = new TextField();
			title.x = 0;
			title.y = 30;
			title.width = 640;
			title.height = 140;
			title.defaultTextFormat = titleFormat;
			title.text = gameName;
			addChild(title);

			var versionFormat:TextFormat = new TextFormat(null, 42, 0xFF00FF, null, null, null, null, null, TextFormatAlign.CENTER);
			var ver:TextField = new TextField();
			ver.x = 0;
			ver.y = 150;
			ver.width = 640;
			ver.height = 50;
			ver.defaultTextFormat = versionFormat;
			ver.text = subtitle;
			addChild(ver);

			_startMode = startMode;
			_startButton = new TextButton(startButtonName, 300, 40);
			_startButton.x = 10;
			_startButton.y = 420;
			addChild(_startButton);
			_startButton.addEventListener(MouseEvent.MOUSE_UP, handleStart);

			_aboutMode = aboutMode;
			_aboutButton = new TextButton(aboutButtonName, 300, 40);
			_aboutButton.x = 330;
			_aboutButton.y = 420;
			addChild(_aboutButton);
			_aboutButton.addEventListener(MouseEvent.MOUSE_UP, handleAbout);

			var crFormat:TextFormat = new TextFormat(null, 15, 0xFFFFFF, null, null, null, null, null, TextFormatAlign.CENTER);
			var copyright:TextField = new TextField();
			copyright.x = 0;
			copyright.y = 460;
			copyright.width = 640;
			copyright.height = 20;
			copyright.defaultTextFormat = crFormat;
			copyright.wordWrap = true;
			copyright.text = copyrt;
			addChild(copyright);
			
			_setup = new PlayerSetup();
			_setup.y = 200;
			addChild(_setup);
		}

// ***** Functions - Event Handling *****************************************

		private function handleStart(evt:Event):void
		{
			// first make sure not a null game
			var validGame:Boolean = false;
			
			for (var cntr:int = 0; cntr < 6; ++cntr)
				if (_setup.getPlayerType(cntr) != PlayerSetup.PLAYER_NONE)
					validGame = true;
			
			if (validGame)
				_game.changeMode(_startMode);
		}

		private function handleAbout(evt:Event):void
		{
			_game.changeMode(_aboutMode);
		}
	}
}
