/*
Dozen Days of Words episode 1: Scrambled Chain
Copyright (c) 2008, 2009 Blazing Games Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
package com.blazinggames.dozendays.words
{
	import flash.display.SimpleButton;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import flash.text.TextFormatAlign;

	import com.blazinggames.dozendays.TextButton;

	public class LetterTile
	extends Sprite
	{
// ***** CONSTANTS **********************************************************

		public static const TILE_SELECTED_EVENT:String = "TileSelected";

// ***** VARIABLES **********************************************************

		protected var _text:TextField;
		protected var _letter:String;

// ***** CONSTRUCTOR ********************************************************

		public function LetterTile(w:int, h:int, s:String = "x", colour:uint = 0xFFFF00, backcolour:uint=0x404040)
		{
			var fontSize:Number = Math.min(w, h) * 0.75;
			var textFormat:TextFormat = new TextFormat(null, fontSize, colour, null, null, null, null, null, TextFormatAlign.CENTER);
			_text = new TextField();
			_text.width = w;
			_text.height = h;
			_text.defaultTextFormat = textFormat;
			_text.background = true;
			_text.backgroundColor = backcolour;
			_text.text = s;
			_text.addEventListener(MouseEvent.MOUSE_UP, handleTileSelection);
			addChild(_text);
			_letter = s;
		}

// ***** Functions - Getting and Setting**************************************

		public function setColors(colour:uint = 0xFFFF00, backcolour:uint=0x404040):void
		{
			_text.backgroundColor = backcolour;
			_text.textColor = colour;			
		}

		public function setLetter(s:String):void
		{
			_text.text = s;
			_letter = s;
		}
		
		public function getLetter():String
		{
			return _letter;
		}
		
		public function setBorder(hasBorder:Boolean, borderColour:uint = 0):void
		{
			_text.border = hasBorder;
			_text.borderColor = borderColour;
		}
// ***** Functions - Event passing **************************************

		private function handleTileSelection(evt:Event):void
		{
			var evnt:Event = new Event(TILE_SELECTED_EVENT);
			dispatchEvent(evnt);
		}
	}
	
}
