/*
Dozen Days of Words episode 1: Scrambled Chain
Copyright (c) 2008, 2009 Blazing Games Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
package com.blazinggames.dozendays.words.scrambled
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import flash.text.TextFormatAlign;
	import flash.utils.getTimer;

	import com.blazinggames.dozendays.TextButton;
	import com.blazinggames.dozendays.words.LetterTile;

	public class ScrambledGame
	extends Sprite
	{
// ***** CONSTANTS **********************************************************

		public static const DONE_TEXT:String = "Return to Title!";
		public static const WON_TEXT:String = "You Have Won!";
		public static const HINTS_ON_TEXT:String = "Turn Hints OFF";
		public static const HINTS_OFF_TEXT:String = "Turn Hints ON";
		
		public static const TILE_SIZE:int = 80;
		public static const HORIZONAL_GAP:int = 10;
		public static const VERTICAL_GAP:int = 10;
		public static const NUM_WORDS:int = 4;
		public static const SMALL_WORD_LETTERS:int = 4;
		public static const FIRST_WORD_CENTER_X:int = 320;
		public static const FIRST_WORD_TOP_Y:int = 70;

		public static const BACKGROUND_COLOR:uint = 0x000050;
		public static const TILE_COLOR:uint = 0x500050;
		public static const LETTER_COLOR:uint = 0xC000C0;
		public static const HIGHLIGHT_COLOR:uint = 0xFF0050;
		public static const HINT_COLOR:uint = 0x00C000;
		
// ***** VARIABLES **********************************************************

		protected var _scrambled:Scrambled;
		protected var _doneButton:TextButton;
		protected var _tiles:Array;
		protected var _puzzle:XML;
		protected var _words:Array;
		protected var _backdrop:TextField;
		protected var _hintText:TextField;
		protected var _selected:LetterTile;

		protected var _haveWon:TextField;
		
		protected var _hintsEnabled:Boolean;
		protected var _hintButton:TextButton;
		
		protected var _startTime:int;
		protected var _playTime:TextField;

// ***** CONSTRUCTOR ********************************************************

		public function ScrambledGame(scrambled:Scrambled)
		{
			var cntrRow:int, cntrCol:int, rowLength:int, tileX:int, tileY:int;
			_scrambled = scrambled;

			_backdrop = new TextField();
			_backdrop.multiline = true;
			_backdrop.width = 640;
			_backdrop.height = 480;
			_backdrop.textColor = 0xC000C0;
			_backdrop.background = true;
			_backdrop.backgroundColor = BACKGROUND_COLOR;
			addChild(_backdrop);

			var hintFormat:TextFormat = new TextFormat(null, 20, 0xC000C0, null, null, null, null, null, TextFormatAlign.CENTER);
			_hintText = new TextField();
			_hintText.multiline = true;
			_hintText.wordWrap = true;
			_hintText.width = 640;
			_hintText.height = 70;
			_hintText.x = 0;
			_hintText.y = 0;
			_hintText.defaultTextFormat = hintFormat;
			addChild(_hintText);

			_tiles = new Array(NUM_WORDS);
			_words = new Array(NUM_WORDS);
			for (cntrRow = 0; cntrRow < NUM_WORDS; ++cntrRow) {
				rowLength = SMALL_WORD_LETTERS + cntrRow
				tileX = FIRST_WORD_CENTER_X - ((rowLength * (TILE_SIZE + HORIZONAL_GAP)) / 2);
				tileY = FIRST_WORD_TOP_Y + (cntrRow * (TILE_SIZE + VERTICAL_GAP));
				_tiles[cntrRow] = new Array(rowLength);
				for (cntrCol = 0; cntrCol < rowLength; ++cntrCol) {
					_tiles[cntrRow][cntrCol] = new LetterTile(TILE_SIZE,TILE_SIZE,"?");
					_tiles[cntrRow][cntrCol].x = tileX;
					tileX += TILE_SIZE;
					tileX += HORIZONAL_GAP;
					_tiles[cntrRow][cntrCol].y = tileY;
					_tiles[cntrRow][cntrCol].setColors(LETTER_COLOR, TILE_COLOR);
					_tiles[cntrRow][cntrCol].addEventListener(LetterTile.TILE_SELECTED_EVENT, handleTileSelection);
					addChild(_tiles[cntrRow][cntrCol]);
				}
			}
			_selected = null;
			
			_doneButton = new TextButton(DONE_TEXT, 200, 40);
			_doneButton.x = 10;
			_doneButton.y = 440;
			addChild(_doneButton);
			_doneButton.addEventListener(MouseEvent.MOUSE_UP, handleExit);

			var timeFormat:TextFormat = new TextFormat(null, 24, 0xC0C0C0, null, null, null, null, null, TextFormatAlign.CENTER);
			_playTime = new TextField();
			_playTime.width = 220;
			_playTime.height = 40;
			_playTime.x = 210;
			_playTime.y = 440;
			_playTime.defaultTextFormat = timeFormat;
			addChild(_playTime);
			
			_hintsEnabled = false;
			_hintButton = new TextButton(HINTS_OFF_TEXT, 200,40)
			_hintButton.x = 430;
			_hintButton.y = 440;
			addChild(_hintButton);
			_hintButton.addEventListener(MouseEvent.MOUSE_UP, handleHints);
			
			var winFormat:TextFormat = new TextFormat(null, 90, 0xFFFF00, null, null, null, null, null, TextFormatAlign.CENTER);
			_haveWon = new TextField();
			_haveWon.width = 640;
			_haveWon.height = 150;
			_haveWon.y = 200;
			_haveWon.defaultTextFormat = winFormat;
			_haveWon.text = WON_TEXT;
			_haveWon.visible = false;
			addChild(_haveWon);
			
			scrambled.stage.addEventListener(Event.ENTER_FRAME, handleEnterFrame);

		}

// ***** Functions - Puzzle Handling ****************************************

		public function setPuzzleData(puzzle:XML):void 
		{
			_puzzle = puzzle;
/*			
			var s:String  = "Puzzle info\n";
			var cntr:int;
			s += "num puzzles = " + puzzle.PUZZLE.length();
			s += "\nwords of four = " + puzzle.PUZZLE.FOURWORD.length();
			for (cntr = 0; cntr < puzzle.PUZZLE[0].FOURWORD.length(); ++cntr)
				s += ";"+puzzle.PUZZLE[0].FOURWORD[cntr];
			s += "\nwords of five = " + puzzle.PUZZLE[0].FIVEWORD.length();
			for (cntr = 0; cntr < puzzle.PUZZLE.FIVEWORD.length(); ++cntr)
				s += ";"+puzzle.PUZZLE.FIVEWORD[cntr];
			s += "\nwords of six = " + puzzle.PUZZLE.SIXWORD.length();
			for (cntr = 0; cntr < puzzle.PUZZLE.SIXWORD.length(); ++cntr)
				s += ";"+puzzle.PUZZLE.SIXWORD[cntr];
			s += "\nwords of seven = " + puzzle.PUZZLE.SEVENWORD.length();
			for (cntr = 0; cntr < puzzle.PUZZLE.SEVENWORD.length(); ++cntr)
				s += ";"+puzzle.PUZZLE.SEVENWORD[cntr];
			_backdrop.text = s;
*/
		}
		
		public function startGame(puzzleIndex:int = -1):void
		{
			var puzzle:int = Math.floor(Math.random() * _puzzle.PUZZLE.length());
			if (puzzleIndex >= 0)
				puzzle = puzzleIndex;
			var s:String = "Using puzzle #" + puzzle;
			var indx:int = Math.floor(Math.random() * _puzzle.PUZZLE[puzzle].FOURWORD.length());
			var cntrRow:int, cntrCol:int;
			var letters:Array = new Array(22);
			var temp:String;
			_words[0] = _puzzle.PUZZLE[puzzle].FOURWORD[indx];
			temp = _words[0];
			for (cntrCol = 0; cntrCol < 4; ++cntrCol)
				letters[cntrCol] = temp.charAt(cntrCol);
			s += "\nFour letter word: " + _words[0];
			
			indx = Math.floor(Math.random() * _puzzle.PUZZLE[puzzle].FIVEWORD.length());
			_words[1] = _puzzle.PUZZLE[puzzle].FIVEWORD[indx];
			temp = _words[1];
			for (cntrCol = 0; cntrCol < 5; ++cntrCol)
				letters[4+cntrCol] = temp.charAt(cntrCol);
			s += "\nFive letter word: " + _words[1];

			indx = Math.floor(Math.random() * _puzzle.PUZZLE[puzzle].SIXWORD.length());
			_words[2] = _puzzle.PUZZLE[puzzle].SIXWORD[indx];
			temp = _words[2];
			for (cntrCol = 0; cntrCol < 6; ++cntrCol)
				letters[9+cntrCol] = temp.charAt(cntrCol);
			s += "\nSix letter word: " + _words[2];
			
			indx = Math.floor(Math.random() * _puzzle.PUZZLE[puzzle].SEVENWORD.length());
			_words[3] = _puzzle.PUZZLE[puzzle].SEVENWORD[indx];
			temp = _words[3];
			for (cntrCol = 0; cntrCol < 7; ++cntrCol)
				letters[15+cntrCol] = temp.charAt(cntrCol);
			s += "\nSeven letter word: " + _words[3];

			for (cntrCol = 0; cntrCol < letters.length; ++cntrCol) {
				indx = Math.floor(Math.random() * letters.length);
				temp = letters[indx];
				letters[indx] = letters[cntrCol];
				letters[cntrCol] = temp;
			}

			for (cntrCol = 0; cntrCol < letters.length; ++cntrCol)
				if (letters[cntrCol] == null)
					letters[cntrCol] = "*";
					
			indx = 0;
			for (cntrRow = 0; cntrRow < NUM_WORDS; ++cntrRow)
				for (cntrCol = 0; cntrCol < _tiles[cntrRow].length; ++cntrCol) {
					_tiles[cntrRow][cntrCol].setLetter(letters[indx]);
					++indx;
				}
			
			_haveWon.visible = false;
			if (_selected != null) {
				_selected.setBorder(false);
				_selected = null;
			}
			
			 _startTime = getTimer();
			 _hintText.text = _puzzle.PUZZLE[puzzle].HINT;
			checkForWin();
//			 _backdrop.text = s;
		}

		public function checkForWin():void
		{
			var haveWon:Boolean = true;

			for (var cntrRow:int = 0; cntrRow < NUM_WORDS; ++cntrRow) {
				var rowLength:int = SMALL_WORD_LETTERS + cntrRow;
				var s:String;
				for (var cntrCol:int = 0; cntrCol < rowLength; ++cntrCol) {
					s = _tiles[cntrRow][cntrCol].getLetter();
					if (_words[cntrRow].charAt(cntrCol) == s) {
						_tiles[cntrRow][cntrCol].setBorder(_hintsEnabled, HINT_COLOR);
					} else {
						_tiles[cntrRow][cntrCol].setBorder(_hintsEnabled, TILE_COLOR);
						haveWon = false;
					}
				}
			}
			_haveWon.visible = haveWon;
		}

// ***** Functions - Event Handling *****************************************

		private function handleExit(evt:Event):void
		{
			_scrambled.changeMode(Scrambled.MODE_TITLE);
		}
		
		private function handleHints(evt:Event):void
		{
			_hintsEnabled = !_hintsEnabled;
			if (_hintsEnabled) 
				_hintButton.setLabel(HINTS_ON_TEXT);
			else
				_hintButton.setLabel(HINTS_OFF_TEXT);
			checkForWin();
		}

		private function handleTileSelection(evt:Event):void
		{
			if (_haveWon.visible)
				return;
			if (_selected == null) {
				_selected = LetterTile(evt.target);
				_selected.setBorder(true, HIGHLIGHT_COLOR);
			} else {
				var secondTile:LetterTile = LetterTile(evt.target);
				var temp:String = _selected.getLetter();
				_selected.setLetter(secondTile.getLetter());
				_selected.setBorder(false);
				_selected = null;
				secondTile.setLetter(temp);
				checkForWin();
			}
		}

		public function handleEnterFrame(evt:Event):void
		{
			if (_haveWon.visible)
				return;
			var newTime:int = getTimer();
			var playTime:int = (newTime - _startTime) / 1000;
			var seconds:int = playTime % 10;
			playTime /= 10;
			var tens:int = playTime % 6;
			var minutes:int = playTime / 6;
			_playTime.text = "Time = " + minutes + ":" +tens + seconds;
		}

	}
}
