/*
Dozen Days of Words episode 1: Scrambled Chain
Copyright (c) 2008, 2009 Blazing Games Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
package com.blazinggames.dozendays.words.scrambled
{
	import flash.display.SimpleButton;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import flash.text.TextFormatAlign;

	import com.blazinggames.dozendays.TextButton;

	public class ScrambledTitle
	extends Sprite
	{
// ***** CONSTANTS **********************************************************

		public static const START_TEXT:String = "Start the Game!";
		public static const ABOUT_TEXT:String = "About the Game!";
		public static const RANDOM_PUZZLE_TEXT:String = "Random puzzle"
		private static const COPYRIGHT_TXT:String = 
"Developed by Billy D. Spelchan. Copyright \xa9 2008, 2009 Blazing Games Inc.";

// ***** VARIABLES **********************************************************

		protected var _scrambled:Scrambled;
		protected var _startButton:TextButton;
		protected var _aboutButton:TextButton;
		
		protected var _puzzleName:TextField;
		protected var _nextPuzzle:TextButton;
		protected var _prevPuzzle:TextButton;
		protected var _puzzleData:XML;
		protected var _selectedPuzzle:int;
		
// ***** CONSTRUCTOR ********************************************************

		public function ScrambledTitle(scrambled:Scrambled, puzzle:XML)
		{
			_puzzleData = puzzle;
			_scrambled = scrambled;
			var titleFormat:TextFormat = new TextFormat(null, 110, 0xFFFF00, null, null, null, null, null, TextFormatAlign.CENTER);
			var title:TextField = new TextField();
			title.x = 0;
			title.y = 10;
			title.width = 640;
			title.height = 280;
			title.multiline = true;
			title.wordWrap = true;
			title.defaultTextFormat = titleFormat;
			title.text = "Scrambled Pyramid";
			addChild(title);

			var puzzleFormat:TextFormat = new TextFormat(null, 32, 0xFFFF00, null, null, null, null, null, TextFormatAlign.CENTER);
			_puzzleName = new TextField();
			_puzzleName.x = 50;
			_puzzleName.y = 280;
			_puzzleName.width = 540;
			_puzzleName.height = 40;
			_puzzleName.defaultTextFormat = puzzleFormat;
			_puzzleName.background = true;
			_puzzleName.border = true;
			_puzzleName.borderColor = 0xFFFFFF;
			_puzzleName.backgroundColor = 0x000050;
			_puzzleName.text = RANDOM_PUZZLE_TEXT;
			addChild(_puzzleName);
			_selectedPuzzle = -1;

			_prevPuzzle = new TextButton("<", 40, 40);
			_prevPuzzle.x = 10;
			_prevPuzzle.y = 280;
			addChild(_prevPuzzle);
			_prevPuzzle.addEventListener(MouseEvent.MOUSE_UP, handlePrevButton);

			_nextPuzzle = new TextButton(">", 40, 40);
			_nextPuzzle.x = 590;
			_nextPuzzle.y = 280;
			addChild(_nextPuzzle);
			_nextPuzzle.addEventListener(MouseEvent.MOUSE_UP, handleNextButton);
			
			_startButton = new TextButton(START_TEXT, 300, 40);
			_startButton.x = 10;
			_startButton.y = 350;
			addChild(_startButton);
			_startButton.addEventListener(MouseEvent.MOUSE_UP, handleStart);

			_aboutButton = new TextButton(ABOUT_TEXT, 300, 40);
			_aboutButton.x = 320;
			_aboutButton.y = 350;
			addChild(_aboutButton);
			_aboutButton.addEventListener(MouseEvent.MOUSE_UP, handleAbout);

			var crFormat:TextFormat = new TextFormat(null, 15, 0xFFFFFF, null, null, null, null, null, TextFormatAlign.CENTER);
			var copyright:TextField = new TextField();
			copyright.x = 0;
			copyright.y = 460;
			copyright.width = 640;
			copyright.height = 20;
			copyright.defaultTextFormat = crFormat;
			copyright.wordWrap = true;
			copyright.text = COPYRIGHT_TXT;
			addChild(copyright);
		}

		public function getSelectedPuzzle():int
		{
			return _selectedPuzzle;
		}

// ***** Functions - Event Handling *****************************************

		private function handleStart(evt:Event):void
		{
			_scrambled.changeMode(Scrambled.MODE_GAME);
		}

		private function handleAbout(evt:Event):void
		{
			_scrambled.changeMode(Scrambled.MODE_ABOUT);
		}

		private function handleNextButton(evt:Event):void
		{
			++_selectedPuzzle;
			if (_selectedPuzzle >= _puzzleData.PUZZLE.length())
				_selectedPuzzle = -1;
			if (_selectedPuzzle >= 0)
				_puzzleName.text = _puzzleData.PUZZLE[_selectedPuzzle].NAME;
			else
				_puzzleName.text = RANDOM_PUZZLE_TEXT;
		}

		private function handlePrevButton(evt:Event):void
		{
			--_selectedPuzzle;
			if (_selectedPuzzle < -1)
				_selectedPuzzle = _puzzleData.PUZZLE.length()-1;
			if (_selectedPuzzle >= 0)
				_puzzleName.text = _puzzleData.PUZZLE[_selectedPuzzle].NAME;
			else
				_puzzleName.text = RANDOM_PUZZLE_TEXT;
		}
	}
}
